<?php

namespace App\Http\Controllers;

use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Services\Nati\InformationNutritionalService;

class InformationNutritionalController
{
    protected $service;

    public function __construct(InformationNutritionalService $service)
    {
        $this->service = $service;
    }

    public function show($id) {
        try {
            return $this->service->getById($id);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => 'true',
                'message' => $e->getMessage()
            ]);
        }
    }
}
