<?php
/**
 * Created by PhpStorm.
 * User: Kaio F.
 * Date: 09/10/2017
 * Time: 16:17
 */

namespace App\Http\Controllers;


use App\Http\Controllers\Controller;
use App\Http\Requests\Nati\EstoqueCreateRequest;
use App\Http\Requests\Nati\EstoqueUpdateRequest;
use App\Services\Nati\SaldoEstoqueService;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Prettus\Validator\Exceptions\ValidatorException;
use Illuminate\Http\Request;
use App\Entities\Logs;

class SaldoEstoqueController extends Controller
{
    protected $service;

    public function __construct(SaldoEstoqueService $service)
    {
        $this->service = $service;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        return response()->json($this->service->get());
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  EstoqueCreateRequest $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(EstoqueCreateRequest $request)
    {
        dd($request);
        try {
            $response = $this->service->insert($request->all());
            return response()->json($response);

        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        try {
            return response()->json($this->service->getById($id));

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  EstoqueUpdateRequest $request
     * @param  string            $id
     *
     * @return \Illuminate\Http\Response
     */
    public function update(EstoqueUpdateRequest $request, $id)
    {
        try {
            $response = $this->service->update($request->all(), $id);
            return response()->json($response);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);

        } catch (ValidatorException $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessageBag()
            ], 400);
        }
    }


    /**
     * Remove the specified resource from storage.
     *
     * @param  int $id
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $this->service->delete($id);
            return response()->json(true);

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 404);
        }
    }

    public function updateMinimumStock(Request $request)
    {
        try {
            $response = $this->service->updateMinimumStock($request->all());
            $user = auth()->user();
            Logs::writeLog($user->stApelido, "ESTOQUE", 'O USUARIO [' . $user->stApelido . '] AJUSTOU A QUANTIDADE MINIMA DO ESTOQUE');
            return response()->json($response);
        } catch (\Exception $e) {
            return response()->json([
                'error'   => true,
                'message' => $e->getMessage()
            ], 400);
        }
    }
}
