<?php

namespace App\Http\Resources\Nati;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderTabIntegracaoResource extends JsonResource
{

    /**
     * Transform the resource into an array.
     *
     * @param Request
     * @return array
     */
    public function toArray($request)
    {
        return [
            "id" => $this->idComanda,
            "createdAt" => $this->dtFirstDate,
            "updatedAt" => $this->dtLastdate,
            "returnedFromThePos" => $this->flReturn,
            "userId" => $this->idOperadorCaixa,
            "blocked" => $this->flBloqueada,
            "tableId" => $this->idMesa,
            "numberOfPeople" => $this->nrPessoas,
            "issuedAccount" => $this->flConta,
            "terminalId" => $this->idMicroterminallock,
            "inUseBy" => $this->stOperadorlock,
            "customerId" => $this->idCliente,
            "limit" => $this->vrLimite,
            "updatedAt2" => $this->dtAlteracao,
            "discount" => $this->vrDesconto,
            "items" => $this->get_items()
        ];
    }

    public function get_items(){
        $a = array();
        foreach ($this->items as $item ){
            array_push($a, $item->item->stProduto);
        }
        return $a;
    }
}
