<?php

namespace App\Jobs;

use App\Entities\Nati\Ncm;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Str;

class ProcessIbptTable extends \Illuminate\Support\Collection implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    protected $data;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        try {
//            Redis::throttle('key')->allow(50)->every(20)->then(function () {
//                info('Inserting: ' . $this->data['codigo']);

//                Ncm::insert([
//                    'ncm' => $this->data['codigo'],
//                    'description' => str_replace('/',' ',str_replace(',',' ',Str::substr($this->data['descricao'], 0,255)))
//                ]);
//
            Ncm::create([
                'ncm' => $this->data['codigo'],
                'description' => str_replace('/',' ',str_replace(',',' ',Str::substr($this->data['descricao'], 0,255)))
            ]);
//                // Handle job...
//            }, function () {
//                // Could not obtain lock...
//
//                return $this->release(5);
//            });°
        }catch (\Exception $exception){
            $x = $exception->getMessage();
        }



    }
}
