<?php

namespace App\Observers;

use App\Entities\Nati\Categoria;
use Illuminate\Support\Facades\Cache;

class CategoriaObserver
{
    /**
     * Handle the categoria "created" event.
     *
     * @param Categoria $categoria
     * @return void
     */
    public function created(Categoria $categoria)
    {
        Cache::tags(['ListaCategorias'])->flush();
    }

    /**
     * Handle the categoria "updated" event.
     *
     * @param Categoria $categoria
     * @return void
     */
    public function updated(Categoria $categoria)
    {
        Cache::tags(['ListaCategorias'])->flush();
    }

    /**
     * Handle the categoria "deleted" event.
     *
     * @param  Categoria  $categoria
     * @return void
     */
    public function deleted(Categoria $categoria)
    {
        Cache::tags(['ListaCategorias'])->flush();
    }

    /**
     * Handle the categoria "restored" event.
     *
     * @param  Categoria  $categoria
     * @return void
     */
    public function restored(Categoria $categoria)
    {
        Cache::tags(['ListaCategorias'])->flush();
    }

    /**
     * Handle the categoria "force deleted" event.
     *
     * @param  Categoria  $categoria
     * @return void
     */
    public function forceDeleted(Categoria $categoria)
    {
        Cache::tags(['ListaCategorias'])->flush();
    }
}
