<?php

namespace App\Observers;

use App\Entities\PontoDelivery;
use Illuminate\Support\Facades\Cache;

class PontoDeliveryObserver
{
    /**
     * Handle the ponto delivery "created" event.
     *
     * @param  PontoDelivery  $pontoDelivery
     * @return void
     */
    public function created(PontoDelivery $pontoDelivery)
    {
        Cache::tags(['ListaPontosDelivery'])->flush();
    }

    /**
     * Handle the ponto delivery "updated" event.
     *
     * @param  PontoDelivery  $pontoDelivery
     * @return void
     */
    public function updated(PontoDelivery $pontoDelivery)
    {
        Cache::tags(['ListaPontosDelivery'])->flush();
    }

    /**
     * Handle the ponto delivery "deleted" event.
     *
     * @param  PontoDelivery  $pontoDelivery
     * @return void
     */
    public function deleted(PontoDelivery $pontoDelivery)
    {
        Cache::tags(['ListaPontosDelivery'])->flush();
    }

    /**
     * Handle the ponto delivery "restored" event.
     *
     * @param  PontoDelivery  $pontoDelivery
     * @return void
     */
    public function restored(PontoDelivery $pontoDelivery)
    {
        Cache::tags(['ListaPontosDelivery'])->flush();
    }

    /**
     * Handle the ponto delivery "force deleted" event.
     *
     * @param  PontoDelivery  $pontoDelivery
     * @return void
     */
    public function forceDeleted(PontoDelivery $pontoDelivery)
    {
        Cache::tags(['ListaPontosDelivery'])->flush();
    }
}
