<?php

namespace App\Observers;

use App\Entities\Supplier;
use Illuminate\Support\Facades\Cache;

class SupplierObserver
{
    /**
     * Handle the supplier "created" event.
     *
     * @param  Supplier  $supplier
     * @return void
     */
    public function created(Supplier $supplier)
    {
        Cache::tags(['ListaSupplier'])->flush();
    }

    /**
     * Handle the supplier "updated" event.
     *
     * @param  Supplier  $supplier
     * @return void
     */
    public function updated(Supplier $supplier)
    {
        Cache::tags(['ListaSupplier'])->flush();
    }

    /**
     * Handle the supplier "deleted" event.
     *
     * @param  Supplier  $supplier
     * @return void
     */
    public function deleted(Supplier $supplier)
    {
        Cache::tags(['ListaSupplier'])->flush();
    }

    /**
     * Handle the supplier "restored" event.
     *
     * @param  Supplier  $supplier
     * @return void
     */
    public function restored(Supplier $supplier)
    {
        Cache::tags(['ListaSupplier'])->flush();
    }

    /**
     * Handle the supplier "force deleted" event.
     *
     * @param  Supplier  $supplier
     * @return void
     */
    public function forceDeleted(Supplier $supplier)
    {
        Cache::tags(['ListaSupplier'])->flush();
    }
}
