<?php

namespace App\Repositories\Nati;

use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;
use App\Repositories\Nati\KeyRepository;
use App\Entities\Nati\Key;
use App\Validators\Nati\KeyValidator;

/**
 * Class KeyRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class KeyRepositoryEloquent extends BaseRepository implements KeyRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Key::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return KeyValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
