<?php

namespace App\Repositories\Nati;

use App\Entities\Nati\Sector;
use App\Validators\Nati\SectorValidator;
use Prettus\Repository\Eloquent\BaseRepository;
use Prettus\Repository\Criteria\RequestCriteria;

/**
 * Class SetorRepositoryEloquent
 * @package namespace App\Repositories\Nati;
 */
class SectorRepositoryEloquent extends BaseRepository implements SectorRepository
{
    /**
     * Specify Model class name
     *
     * @return string
     */
    public function model()
    {
        return Sector::class;
    }

    /**
    * Specify Validator class name
    *
    * @return mixed
    */
    public function validator()
    {

        return SectorValidator::class;
    }


    /**
     * Boot up the repository, pushing criteria
     */
    public function boot()
    {
        $this->pushCriteria(app(RequestCriteria::class));
    }
}
