<?php

namespace App\Services;

use App\Repositories\PagamentoRepository;
use App\Validators\PagamentoValidator;
use Carbon\Carbon;
use Prettus\Validator\Contracts\ValidatorInterface;

class PagamentoService
{
    private $repository;
    private $validator;

    public function __construct(PagamentoRepository $repository,PagamentoValidator $validator)
    {
        $this->validator = $validator;
        $this->repository = $repository;
        $this->repository->pushCriteria(app('Prettus\Repository\Criteria\RequestCriteria'));

    }

    public function get()
    {
        $pagamentos = $this->repository->all();

        return $pagamentos;
    }
    public function getById($id)
    {

        $pagamentos = $this->repository->find($id);

        return $pagamentos;
    }

    public function insert($data) {

        if ($this->repository->all()->last()){
            $idTipoPagamento = $this->repository->all()->last()->idTipoPagamento;
        }else{
            $idTipoPagamento = 0;
        }

        $data = [
            'idTipoPagamento' => $idTipoPagamento + 1,
            'stTipoPagamento' => $data['stTipoPagamento'],
            'dtAlteracao' => Carbon::now()
        ];
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);
        return $this->repository->create($data);
    }

    public function update($data, $id) {

        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_UPDATE);
        return $this->repository->update($data, $id);
    }

    public function delete($id) {

        return $this->repository->delete($id);
    }

}