<?php
/**
 * Created by PhpStorm.
 * User: ARCNET DEV
 * Date: 13/11/2017
 * Time: 16:16
 */

namespace App\Services;

use App\Repositories\RepiqueRepository;
use App\Validators\Nati\RepiqueValidator;

class RepiqueService
{
    protected $repository;
    protected $validator;

    public function __construct(RepiqueRepository $repository, RepiqueValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function get()
    {
        return $this->repository->with(['formaPagamento', 'operador'])->all();
    }

    public function getByIdAbertura($id)
    {
        return $this->repository->with(['formaPagamento', 'operador'])->findWhere(['idAbertura' => $id]);
    }

    public function getTotalRepique($id)
    {
        return $this->getByIdAbertura($id)->reduce(function ($total, $item) {
            return $total + floatval($item->vrRepique);
        }) | 0;
    }
}
