<?php

namespace App\Transformers;

use App\Entities\Financeiro\ContaBancaria;
use League\Fractal\TransformerAbstract;

/**
 * Class ContaBancariaTransformer
 * @package namespace App\Transformers;
 */
class ContaBancariaTransformer extends TransformerAbstract
{

    /**
     * Transform the \ContaBancaria entity
     * @param \ContaBancaria $model
     *
     * @return array
     */
    public function transform(ContaBancaria $model)
    {
        return [
            'id'         => (int) $model->id,

            /* place your other model properties here */

            'created_at' => $model->created_at,
            'updated_at' => $model->updated_at
        ];
    }
}
