<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Entities\Nati\Code;

class CodeFactory extends Factory
{
        /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Code::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'idCodigo' => $this->faker->ean13(),
            'idProduto' => $this->faker->unique()->numberBetween(1, 100000),
            'dtAlteracao' => \Carbon\Carbon::now(),
            'flPrincipal' => false,
            'vrMultiplo' => 1
        ];
    }
}
