<?php

use Carbon\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdProdutosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Produtos')) {
            Schema::create('prd_Produtos', function (Blueprint $table) {
                $table->integer('idProduto', false, true);
                $table->string('stProduto', 50);
                $table->string('stProdutoAbreviado', 29);
                $table->integer('idMedida', false, true);
                $table->decimal('vrUnitario', 18, 3);
                $table->decimal('vrCusto', 18, 3)->default(0);
                $table->boolean('flAtivo')->default(true);
                $table->string('stOperador', 20);
                $table->integer('idCategoria');
                $table->integer('idSetor');
                $table->integer('idLocalizacao');
                $table->integer('idAliquota');
                $table->float('flComissao')->default(false);
                $table->integer('nrValidade')->default(0);
                $table->float('flControlarEstoque');
                $table->text('stDescricao')->nullable();
                $table->integer('idTipoProduto');
                $table->float('flPocket')->default(0);
                $table->integer('idSubCategoria')->default(1);
                $table->integer('nr10Mais')->default(0);
                $table->dateTime('dtUltimaVenda')->nullable();
                $table->dateTime('dtUltimaAlteracao')->nullable()->default(Carbon::now());
                $table->float('flPromocao')->default(0);
                $table->dateTime('dtInicioPromocao')->default(Carbon::parse('2008-01-01 00:00:00'));
                $table->dateTime('dtFimPromocao')->default(Carbon::parse('2008-01-01 00:00:00'));
                $table->decimal('vrUnitarioPromocao', 18, 3)->default(0);
                $table->float('flVendaCartao')->default(1);
                $table->float('flVendaTicket')->default(1);
                $table->float('flVendaSmart')->default(1);
                $table->float('flRequererItemAdicional')->default(0);
                $table->decimal('vrMargemLucro', 18, 2)->default(0);
                $table->float('flBalanca')->default(0);
                $table->integer('idMedidaCompra')->default(1);
                $table->integer('nrFatorConversao')->nullable();
                $table->dateTime('dtUltimaCompra')->nullable();
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->integer('nrTipoProduto')->default(1);
                $table->integer('idProdutoVinculado')->nullable();
                $table->decimal('vrUnitario2', 18, 3)->default(0);
                $table->float('flCupomPreVenda')->default(0);
                $table->string('idProdutoIntegracao', 14)->nullable();
                $table->dateTime('dtCriacao')->default(Carbon::now());
                $table->float('flDesconto')->default(1);
                $table->string('nrNCM', 8)->nullable()->default(99);
                $table->string('stCest', 7)->nullable();
                $table->float('flPromocaoHora')->nullable()->default(0);
                $table->dateTime('dtInicioPromocaoHora')->nullable()->default(Carbon::parse('2008-01-01 00:00:00'));
                $table->dateTime('dtFimPromocaoHora')->nullable()->default(Carbon::parse('2008-01-01 00:00:00'));
                $table->decimal('vrUnitarioPromocaoHora', 18, 3)->nullable()->default(0);

                $table->primary('idProduto');
            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Produtos');
    }
}
