<?php

use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrdSetoresTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('prd_Setores')) {
            Schema::create('prd_Setores', function (Blueprint $table) {
                $table->smallInteger('idSetor', false, true);
                $table->string('stSetor', 50);
                $table->boolean('flAtivo')->default(1);
                $table->dateTime('dtAlteracao')->default(Carbon::now());
                $table->string('stReservaCodigosInicio', 10)->nullable(true);
                $table->string('stReservaCodigosFim', 10)->nullable(true);
                $table->primary('idSetor');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('prd_Setores');

    }
}
