<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class V52Migrations extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $this->alterProdutosTable();
        $this->alterTableMaster();
    }

    private function alterTableMaster()
    {
        if (Schema::hasTable('Master')) {
            DB::statement($this->deleteConstraintFlExportaIob());

            Schema::table('Master', function (Blueprint $table) {
                if (!Schema::hasColumn('Master', 'vrDiversos')) {
                    $table->decimal('vrDiversos', 9, 2)->default(0);
                }
                if (!Schema::hasColumn('Master', 'vrAliquotaSimplesNacional')) {
                    $table->decimal('vrAliquotaSimplesNacional', 9, 2)->default(0);
                }
                if (Schema::hasColumn('Master', 'flTravarSenhaBiometria')) {
                    $table->dropForeign('DF_Master_flTravarSenhaBiometria');
                    $table->dropColumn('flTravarSenhaBiometria');
                }
                if (Schema::hasColumn('Master', 'flAtivarPosto')) {
                    $table->dropForeign('DF_Master_flAtivarPosto');
                    $table->dropColumn('flAtivarPosto');
                }
                if (Schema::hasColumn('Master', 'nrNFe')) {
                    $table->dropForeign('DF_Master_nrNFe');
                    $table->dropColumn('nrNFe');
                }
                if (Schema::hasColumn('Master', 'vrAliquotaPIS')) {
                    $table->dropForeign('DF_Master_vrAliquotaPIS');

                    $table->dropColumn('vrAliquotaPIS');
                }
                if (Schema::hasColumn('Master', 'vrAliquotaCOFINS')) {
                    $table->dropForeign('DF_Master_vrAliquotaCOFINS');
                    $table->dropColumn('vrAliquotaCOFINS');
                }
                if (Schema::hasColumn('Master', 'perfilSPED')) {
                    $table->dropForeign('DF_Master_perfilSPED');
                    $table->dropColumn('perfilSPED');
                }
                if (Schema::hasColumn('Master', 'atividadeSPED')) {
                    $table->dropForeign('DF_Master_atividadeSPED');
                    $table->dropColumn('atividadeSPED');
                }
                if (Schema::hasColumn('Master', 'indicadorNaturezaPJ')) {
                    $table->dropColumn('indicadorNaturezaPJ');
                }
                if (Schema::hasColumn('Master', 'vrDeducaoDependente')) {
                    $table->dropForeign('DF_Master_vrDeducaoDependente');
                    $table->dropColumn('vrDeducaoDependente');
                }
                if (Schema::hasColumn('Master', 'vrPorcentagemTransporte')) {
                    $table->dropForeign('DF_Master_vrPorcentagemTransporte');
                    $table->dropColumn('vrPorcentagemTransporte');
                }
                if (Schema::hasColumn('Master', 'vrPorcentagemRefeicao')) {
                    $table->dropForeign('DF_Master_vrPorcentagemRefeicao');
                    $table->dropColumn('vrPorcentagemRefeicao');
                }
                if (Schema::hasColumn('Master', 'nrDiaPgtoTransporte')) {
                    $table->dropForeign('DF_Master_nrDiaPgtoTransporte');
                    $table->dropColumn('nrDiaPgtoTransporte');
                }
                if (Schema::hasColumn('Master', 'nrDiaPgtoRefeicao')) {
                    $table->dropForeign('DF_Master_nrDiaPgtoRefeicao');
                    $table->dropColumn('nrDiaPgtoRefeicao');
                }
                if (Schema::hasColumn('Master', 'flExportaIOB')) {
                    $table->dropColumn('flExportaIOB');
                }
            });
        }
    }

    private function alterProdutosTable()
    {
        if (Schema::hasTable('prd_produtos')) {
            Schema::table('prd_produtos', function (Blueprint $table) {
                if (!Schema::hasColumn('prd_Produtos', 'flPromocaoHora')) {
                    $table->boolean('flPromocaoHora')->default(false);
                }
                if (!Schema::hasColumn('prd_Produtos', 'vrUnitarioPromocaoHora')) {
                    $table->decimal('vrUnitarioPromocaoHora', 9, 2)->default(0);
                }
                if (!Schema::hasColumn('prd_Produtos', 'dtInicioPromocaoHora')) {
                    $table->dateTime('dtInicioPromocaoHora')->nullable();
                }
                if (!Schema::hasColumn('prd_Produtos', 'dtFimPromocaoHora')) {
                    $table->dateTime('dtFimPromocaoHora')->nullable();
                }
            });
        }
    }

    public function deleteConstraintFlExportaIob()
    {
        return "DECLARE @MyCursor CURSOR;
                DECLARE @FieldName varchar(200);
                DECLARE @tableName varchar(200) = 'master';
                DECLARE @Column varchar(200) = 'flExportaIOB';
                DECLARE @ShortColumn varchar(200) = 'flExport';
                DECLARE @Cols AS int = (SELECT COUNT(*) FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = @tableName AND COLUMN_NAME = @Column AND TABLE_SCHEMA='DBO')

                IF @Cols > 0
                BEGIN
                    SET @MyCursor = CURSOR FOR
                        SELECT name from sys.default_constraints where parent_object_id =OBJECT_ID(@tableName) AND name like '%' + @ShortColumn + '%'
                    OPEN @MyCursor
                    FETCH NEXT FROM @MyCursor
                    INTO @FieldName
                    WHILE @@FETCH_STATUS = 0
                    BEGIN
                    EXEC('ALTER TABLE ['+ @tableName +'] drop constraint [' + @FieldName + ']')
                        FETCH NEXT FROM @MyCursor
                        INTO @FieldName
                    END
                    EXEC('ALTER TABLE ['+ @tableName +'] drop column [' + @column + ']')
                END";
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {

    }
}
