<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMtAtendimentosExcluidosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('mt_AtendimentosExcluidos')) {

            DB::statement('CREATE TABLE [dbo].[mt_AtendimentosExcluidos](
                  [idAtendimento] [decimal](13, 0) NOT NULL,
                  [idComanda] [smallint] NOT NULL,
                  [dtFirstDate] [smalldatetime] NOT NULL,
                  [dtLastdate] [smalldatetime] NOT NULL,
                  [flReturn] [bit] NOT NULL CONSTRAINT [DF_mt_AtendimentosExcluidos_flReturn]  DEFAULT ((0)),
                  [idOperadorCaixa] [smallint] NOT NULL,
                  [idOperadorExcluiu] [smallint] NOT NULL,
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_mt_AtendimentosExcluidos_dtAlteracao]  DEFAULT (getdate()),
                  CONSTRAINT [PK_mt_AtendimentosExcluidos] PRIMARY KEY CLUSTERED
                    (
                      [idAtendimento] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('mt_AtendimentosExcluidos');

    }
}
