<?php

namespace Database\Seeders;

use Carbon\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class MtMicroterminaisSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        if (!DB::table('mt_Microterminais')->count()) {

            $data = [
                [
                    'idMicroTerminal' => 'MASTER',
                    'stMicroTerminal' => 'MASTER',
                    'stTipo' => 2,
                    'nrPorta' => '6550',
                    'nrTeclas' => 16,
                    'flLeitor' => 1,
                    'flOperador' => 1,
                    'stBalanca' => 'SEM BALANCA',
                    'flModoCheckOut' => 0,
                    'idCaixa' => 0,
                    'idOrigem' => 1,
                    'idDestino' => 2,
                    'stMarcaPrint' => 'SEM IMPRESSORA',
                    'flPrint' => 0,
                    'stTipoPorta' => 'SERIAL',
                    'flPrintAll' => '1',
                    'nrCOMDisplay' => 0,
                    'stDisplay' => 'SEM DISPLAY',
                    'flAtivo' => 1,
                    'dtAlteracao' => Carbon::now(),
                    'nrTabelaPreco' => 1,
                ]
            ];

            DB::table('mt_Microterminais')->insert($data);
        }
    }
}
