<?php

/**
 * Description of Conexao
 *
 * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
 * 
 */

class Conexao {
    
    private $_engine = "";//mssql, mysql ou pgsql
    private $_host = "";
    private $_port = "";
    private $_user = "";
    private $_pass = "";
    private $_dbname = "";
    private $_objConexao = null;
    private $_db_conexao = null;
    private $_msg;
    
    private function setDadosConexao(){
        $path = str_replace("\\", "/", __FILE__);
        $root = str_replace("/database/models/Conexao.class.php", "", $path);
        $dadosConexao = file_get_contents($root.'/secrets.php');
        $DADOS = explode("$", $dadosConexao);
        $CON = array();

        foreach($DADOS as $str) :
            if(substr($str, 0, 2) != "<?") :
                $CON[] = substr($str, strpos($str, '"') + 1, (strrpos($str, '"') - (strpos($str, '"') + 1)));
            endif;
        endforeach;
        
        $this->_host = "".$CON[0]."";
        $this->_user = "".$CON[1]."";
        $this->_pass = "".$CON[2]."";
        $this->_dbname = "".$CON[3]."";
    }
    
    protected function getMessage(){
        return $this->_msg;
    }
    protected function setMessage($msg){
        $this->_msg = $msg;
    }
    
    private function abrir(){
        try{
            $this->setDadosConexao();
            $this->_objConexao = mssql_connect($this->_host,$this->_user,$this->_pass) or die("ERROR - Erro ao tentar conectar a base de dados: " . mssql_get_last_message());
            $this->_db_conexao = mssql_select_db($this->_dbname, $this->_objConexao) or die ("ERROR - Erro ao selecionar base de dados: " . mssql_get_last_message());
        }catch(Exception $ex){
            $this->_msg = "FATAL ERROR - Erro ao tentar se conectar com a base de dados: " . $ex->getMessage();
            $this->_objConexao = null;
        }
    }
    
    /**
     * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
     * @param string $SQL Passar uma query em forma de String para ser executado no banco de dados
     * @param array $SQL Passar um array com varias querys para ser executado no banco de dados
     * @access Elemento de acesso protegido
     * @return false Caso não obtenha sucesso, retorna um false
     * @return Statment Caso tenha sucesso, ele retorna um PDOStatment
     */
    protected function executar($SQL){
        try{
            self::abrir();
            if(is_array($SQL)){
                foreach($SQL as $qry){
                    if(!empty($qry)) :
                        $objSource = self::execQry($qry);
                    endif;
                }
            }else{
                $objSource = self::execQry($SQL);
            }
            //self::fechar();
            return $objSource;
        }catch(PDOException $ex){
            self::fechar();
            $this->_msg = "FATAL ERROR - erro ao tentar executar query na base de dados: " + $ex->getMessage();
            throw (new Exception($this->_msg));
            return false;
        }
    }

    protected function getQuery($query){
        $sql = self::executar($query);
        $resultArray = array();
        $pos = 0;
        if (mssql_num_rows($sql) > 0) {
            while ($arr = mssql_fetch_array($sql)) {
                $arr = Util::removeRedundanceData($arr);
                $resultArray[$pos++] = $arr;
            }
        } else {
            $this->_msg = 'Nenhum resultado encontrado!';
            return false;
        }
        return $resultArray;
    }

    public function dbDate(){
        $query = "SELECT getDate()";
        $sql = $this->executar($query);
        if(mssql_num_rows($sql) > 0){
            $arr = mssql_fetch_array($sql);
            return $arr[0];
        }
        else{
            $this->_msg = 'Nenhuma permissão encontrada!';
            return date('y-m-y H:i:s');
        }
    }
    
    private function execQry($sql){
        try{
            $objSource = mssql_query($sql, $this->_objConexao) or new Exception("Erro ao tentar executar Query na base de dados:  " . mssql_get_last_message());
            return $objSource;
        }catch(Exception $ex){
            $this->_msg = "ERROR - Erro ao tentar executar query na base de dados: " . $ex->getMessage() . $sql;
            throw(new Exception($this->_msg));
            return false;
        }
    }
    
    private function fechar(){
        mssql_close($this->_objConexao);
    }

    protected function checkTableExists($tableName){
        $query = "IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = N'".$tableName."')) select '1' as [Exists] else select '0' as [Exists]";
        $sql = self::executar($query);
        if(mssql_num_rows($sql) > 0){
            $arr = mssql_fetch_array($sql);
            return $arr[0];
        }
        return false;
    }

    protected function checkColumnExists($tableName, $columnName){
        $query = "IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = N'".$tableName."' AND COLUMN_NAME=N'".$columnName."' COLLATE Latin1_General_CS_AS)) select '1' as [Exists] else select '0' as [Exists]";
        $sql = self::executar($query);
        if(mssql_num_rows($sql) > 0){
            $arr = mssql_fetch_array($sql);
            return $arr[0];
        }
        return false;
    }

    protected function createFile($fileName, $data){
        $fopen = fopen($fileName, "w");
        fwrite($fopen, $data);
        fclose($fopen);
    }

    protected function addColum($column, $query){
        if(self::checkColumnExists($this->getName(), $column))return true;
        $query = str_replace("#columnName", $column, $query);
        self::executar($query);
    }

    protected function updateColum($column, $query){
        if(!self::checkColumnExists($this->getName(), $column))return true;
        $query = str_replace("#columnName", $column, $query);
        self::executar($query);
    }

    protected function removeColum($tableName, $column){
        $query = "
        DECLARE @sql NVARCHAR(MAX)
        WHILE 1=1
        BEGIN
            SELECT TOP 1 @sql = N'alter table ".$tableName." drop constraint ['+dc.NAME+N']' from sys.default_constraints dc
            JOIN sys.columns c ON c.default_object_id = dc.object_id
            WHERE dc.parent_object_id = OBJECT_ID('".$tableName."') AND c.name = N'".$column."'
            IF @@ROWCOUNT = 0 BREAK
            EXEC (@sql)
        END
        IF EXISTS(select * from INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '".$tableName."' AND COLUMN_NAME = '".$column."') ALTER TABLE ".$tableName." DROP COLUMN ".$column;
        self::executar($query);
    }

    protected function renameColum($columnFrom, $columnTo){
        if(self::checkColumnExists($this->getName(), $columnTo))return true;
        if(!self::checkColumnExists($this->getName(), $columnFrom))return true;
        $query = "EXEC sp_rename '".$this->getName().".".$columnFrom."', '".$columnTo."', 'COLUMN'";
        self::executar($query);
    }

    protected function getDbArray($query){
        $sql = self::executar($query);
        $resultArray = array();
        $pos = 0;
        if (mssql_num_rows($sql) > 0) {
            while ($arr = mssql_fetch_array($sql)) {
                $arr = Util::removeRedundanceData($arr);
                $resultArray[$pos++] = $arr;
            }
        } else {
            self::setMessage('Nenhum produto encontrado!');
            $resultArray = array();
        }
        return $resultArray;
    }
}