<?php
/**
 * Description of Conexao
 *
 * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
 * 
 */
class VwAtendimentos extends Conexao {
    private $_name = "vw_atendimentos";
    private $_msg;
    
    public function __construct(){
        $sql = "IF OBJECT_ID('".$this->_name."') IS NULL
                CREATE VIEW ".$this->_name." AS
                SELECT A.idAtendimento, A.dtSaidaMotoboy as dtData, I.vrTotal, A.stStatus, A.flPago, A.flAtivo, C.idCodigo, M.idMotoBoy
                FROM dlv_Atendimentos A
                INNER JOIN dlv_Itens I ON A.idAtendimento = I.idAtendimento
                INNER JOIN prd_Produtos P ON I.idProduto = P.idProduto
                INNER JOIN prd_Codigos C ON P.idProduto = C.idProduto
                INNER JOIN dlv_Motoboy M ON A.idMotoboy = M.idMotoboy
                ORDER BY A.dtSaidaMotoboy ASC;
                ";
        try{
            parent::executar($sql);
        }catch(Exception $ex){
            $this->_msg = "Erro ao tentar verificar/criar view em base de dados: ". $ex->getMessage();
        }
    }
    
    public function getMessage() {
        return $this->_msg;
    }
    
    public function getEntregasDia($data, $idmotoboy){
        $sql = "SELECT DAY(dtData) AS dtDia, 
                    MONTH(dtData) AS dtMes, 
                    YEAR(dtData) AS dtAno, 
                    SUM(vrTotal) as vrTotal, 
                    idMotoboy,
                    COUNT(idAtendimento) as nrEntregas 
                FROM ".$this->_name." WHERE stStatus = 'E' AND flPago = 'true' AND flAtivo = 'true' AND idCodigo = '-100'
                AND dtData BETWEEN '".Util::inverteDataBanco($data)." 00:00:00' AND '".Util::inverteDataBanco($data)." 23:59:59' AND idMotoboy = ".$idmotoboy." 
                GROUP BY DAY(dtData), MONTH(dtData), YEAR(dtData), idMotoboy";
        return parent::executar($sql);
    }
    
}
