<?php

namespace App\Entities\Financeiro;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class SubGrupo extends Model implements Transformable
{
    use TransformableTrait;

    protected $primaryKey = 'idTipoConta';
    protected $table  = "fin_TipoContas";
    public $timestamps = false;

    protected $fillable = [
        "idTipoConta",
        "idCategoriaConta",
        "stTipoConta",
        "flEntrada",
        "idClassificacao",
        "dtAlteracao"
    ];
    protected $casts = [
        "idTipoConta" => 'int',
        "idCategoriaConta" => 'int',
        "flEntrada" => 'boolean',
        "idClassificacao" => 'int',
    ];
    public function grupo() {

        return $this->belongsTo(Grupo::class, 'idCategoriaConta');
    }

    public function conta() {

        return $this->hasMany(Conta::class, 'idTipoConta');
    }

}
