<?php

namespace App\Entities\Nati;

use App\Traits\HasCompositePrimaryKey;
use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class CustomerPayment extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cli_Pagamento';
    protected $primaryKey = ['idPagamento', 'idAbertura'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'id',
        'id_open',
        'id_customer',
        'id_operator',
        'date',
        'value_payment',
        'id_payment',
        'id_operator_authorizer',
        'active',
        'previous_balance',
        'id_invoice',
        'change',
        'update_date',
        'id_bank',
        'check',
        'agency_check',
        'account_check',
        'deposit_check',
        'conferred'
    ];

    protected $appends = [
        'id',
        'id_open',
        'id_customer',
        'id_operator',
        'date',
        'value_payment',
        'id_payment',
        'id_operator_authorizer',
        'active',
        'previous_balance',
        'id_invoice',
        'change',
        'update_date',
        'id_bank',
        'check',
        'agency_check',
        'account_check',
        'deposit_check',
        'customer',
        'id_type_payment',
        'payment',
        'conferred'
    ];

    protected $hidden = [
        'idPagamento',
        'idAbertura',
        'idCliente',
        'idOperador',
        'dtData',
        'vrPagamento',
        'idFormaPagamento',
        'idOperadorAutorizador',
        'flAtivo',
        'vrSaldoAnterior',
        'idFatura',
        'vrTroco',
        'dtAlteracao',
        'idBanco',
        'nrCheque',
        'nrAgenciaCheque',
        'nrContaCheque',
        'dtDepositoCheque',
        'formaPagamento',
        'cliente',
        'flConferido'
    ];

    protected $maps = [
        'id' => 'idPagamento',
        'id_open' => 'idAbertura',
        'id_customer' => 'idCliente',
        'id_operator' => 'idOperador',
        'date' => 'dtData',
        'value_payment' => 'vrPagamento',
        'id_payment' => 'idFormaPagamento',
        'id_operator_authorizer' => 'idOperadorAutorizador',
        'active' => 'flAtivo',
        'previous_balance' => 'vrSaldoAnterior',
        'id_invoice' => 'idFatura',
        'change' => 'vrTroco',
        'update_date' => 'dtAlteracao',
        'id_bank' => 'idBanco',
        'check' => 'nrCheque',
        'agency_check' => 'nrAgenciaCheque',
        'account_check' => 'nrContaCheque',
        'deposit_check' => 'dtDepositoCheque',
        'customer' => 'cliente.name',
        'id_type_payment' => 'formaPagamento.idTipo',
        'payment' => 'formaPagamento.stFormaPagamento',
        'conferred' => 'flConferido'
    ];

    protected $casts = [
        'flAtivo' => 'boolean',
        'flConferido' => 'boolean',
    ];

    public function cliente()
    {
        return $this->belongsTo(Customer::class, 'idCliente', 'idCliente');
    }

    public function formaPagamento()
    {
        return $this->belongsTo(FormaPagamento::class, 'idFormaPagamento', 'idFormaPagamento');
    }
}
