<?php

namespace App\Entities\Nati;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;


/**
 * Class RespostaProduto.
 *
 * @package namespace App\Entities\Nati;
 */


class RespostaProduto extends Model implements Transformable
{
    use TransformableTrait;
    protected $table = "prd_RespostaProduto";
    protected $primaryKey = 'idRespostaProduto';
    public $incrementing = true;
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'idProduto',
        'vrUnitario',
        'flAtivo',
        'dtAlteracao',
    ];
    protected $casts = [
        'idRespostaProduto' => 'integer',
        'idProduto' => 'integer',
        'vrUnitario' => 'float',
    ];

}
