<?php

namespace App\Http\Controllers\Auth;

use App\Entities\Logs;
use App\Entities\User;
use Illuminate\Support\Str;
use App\Events\UserLoggedIn;
use Illuminate\Http\Request;
use Illuminate\Support\MessageBag;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Cookie;
use App\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use League\Event\Event;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = RouteServiceProvider::HOME;

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest')->except('logout');
    }

    public function login(Request $request)
    {
        $this->validate($request, [
            'username' => 'required|min:2',
            'password' => 'required',
        ]);

        $username = $request->username;
        $password = $request->password;
        $pswd = Str::upper(md5($password));

        if (is_numeric($username)) {
            $user = User::where('flAtivo', true)->find($username);
        } else {
            //busca o usuario pelo apelido
            $user = User::where('stApelido', $username)->where('flAtivo', true)->first();
        }

        if ($user == null || $pswd != Str::upper($user->stSenha)) {
            $erro = new MessageBag();
            $erro->add('user_pswd_not_found', 'user or password not found!');
            return back()->withErrors($erro);
        }

        $hasAcesso = $user->hasAcesso(8);

        if ($user && Str::upper($user->stSenha) == $pswd && $hasAcesso) {
            Auth::login($user);
            Cookie::queue(Cookie::make('idOperador', $user->idOperador, 120));
            Cookie::queue(Cookie::make('stSenha', $user->stSenha, 120));
            Logs::writeLog($user->stApelido, 'NATI', ' O OPERADOR ['.$user->stApelido.'] LOGOU NO SISTEMA');
            event(new UserLoggedIn($user));
            return redirect()->intended();
        } else {
            $erro = new MessageBag();
            $erro->add('user_pswd_not_found', 'user or password not found!');
            return back()->withErrors($erro);
        }
    }

    public function logout(Request $request)
    {
        Cookie::queue(Cookie::forget('stSenha'));
        Cookie::queue(Cookie::forget('idOperador'));
        Artisan::call('cache:clear');
        Auth::logout();
        return redirect('/login');
    }

    /**
     * Validate the user login request.
     *
     * @param \Illuminate\Http\Request $request
     * @return void
     */
    protected function validateLogin(Request $request)
    {
        $this->validate($request, [
            $this->username() => 'required|string',
            'password' => 'required|string',
        ]);
    }


    public function username()
    {
        return 'idOperador';
    }
}
