<?php

namespace App\Http\Controllers;

use App\Entities\Nati\Key;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use App\Http\Requests\Nati\PontoDeliveryCreateRequest;
use App\Http\Requests\Nati\PontoDeliveryUpdateRequest;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use Prettus\Validator\Exceptions\ValidatorException;
use App\Services\Nati\PontoDeliveryService;
use App\Http\Controllers\Controller;
use App\Services\Nati\KeyService;


class PontoDeliveryController extends Controller
{
    protected $service;
    protected $key;

    public function __construct(PontoDeliveryService $service, KeyService $key)
    {
        $this->service = $service;
        $this->key = $key;
    }

    public function index()
    {
        try {
            $pontos =$this->service->get();
            return response()->json($pontos);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function store(PontoDeliveryCreateRequest $request)
    {
        try {
            return response()->json($this->service->insert($request->all()));

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        } catch (\Exception $e) {
            $errorCode = $e->errorInfo[1];
            if ($errorCode == 2627) {
                $message = 'ID Delivery já esta cadastrado.';
            } else {
                $message = $e->getMessage();
            }

            return response()->json([
                'error' => true,
                'message' => $message
            ], 404);
        }
    }

    public function show($id)
    {
        try {
            return response()->json($this->service->getById($id));
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function update(PontoDeliveryUpdateRequest $request, $id)
    {
        try {
            return response()->json($this->service->update($request->all(), $id));

        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessage()
            ], 400);
        } catch (ValidatorException $e) {
            return response()->json([
                'error' => true,
                'message' => $e->getMessageBag()
            ], 404);
        }
    }

    public function destroy($id)
    {
        try {
            return response()->json($this->service->delete($id));
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 404);
        }

    }

    public function delete($id)
    {
        try {
            $pontoDelivery = $this->service->delete($id);
            return response()->json($pontoDelivery);
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => true, 'message' => $e->getMessage()], 404);
        }

    }
}
