<?php

namespace App\Observers;

use App\Entities\Profile;
use Illuminate\Support\Facades\Cache;

class ProfileObserver
{
    /**
     * Handle the profile "created" event.
     *
     * @param Profile $profile
     * @return void
     */
    public function created(Profile $profile)
    {
        Cache::tags(['ListaProfile'])->flush();
    }

    /**
     * Handle the profile "updated" event.
     *
     * @param  Profile  $profile
     * @return void
     */
    public function updated(Profile $profile)
    {
        Cache::tags(['ListaProfile'])->flush();
    }

    /**
     * Handle the profile "deleted" event.
     *
     * @param  Profile  $profile
     * @return void
     */
    public function deleted(Profile $profile)
    {
        Cache::tags(['ListaProfile'])->flush();
    }

    /**
     * Handle the profile "restored" event.
     *
     * @param  Profile  $profile
     * @return void
     */
    public function restored(Profile $profile)
    {
        Cache::tags(['ListaProfile'])->flush();
    }

    /**
     * Handle the profile "force deleted" event.
     *
     * @param  Profile  $profile
     * @return void
     */
    public function forceDeleted(Profile $profile)
    {
        Cache::tags(['ListaProfile'])->flush();
    }
}
