<?php


namespace App\Services;


use App\Entities\ContasReceber;
use App\Entities\Nati\Extract;
use App\Entities\Nati\ItensExtract;
use App\Entities\PaymentMethod;
use App\Entities\SaleTemp;
use App\Entities\TypePaymentMethod;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;

class CliExtratoService
{
    protected $config;

    public function __construct()
    {
        $this->config = (object)app('config')->get('ifood');
    }

    public function save(SaleTemp $sale)
    {
        try {
            DB::beginTransaction();
            $payment = $sale->paymentsTemp()->first();

            if ($payment) {
                $forma = PaymentMethod::with('tipo')->find($payment->idFormaPagamento);
                $tipo = TypePaymentMethod::find($forma->idTipo);

                if ($tipo->idTipoForma == 14) {
                    $idContasReceber = ContasReceber::nextId($sale->idCliente);
                    $conta = ContasReceber::create([
                        'idContasReceber' => $idContasReceber,
                        'idCliente' => $sale->idCliente,
                        'idTipoConta' => $this->config->id_conta_financeiro,
                        'dtLancamento' => Carbon::now(),
                        'dtVencimento' => Carbon::now()->addDay(1),
                        'nrParcela' => 1,
                        'nrTotalParcelas' => 1,
                        'vrDocumento' => $sale->vrTotal,
                        'vrRecebido' => 0,
                        'vrJuros' => 0,
                        'flRecebido' => false,
                        'flAtivo' => true,
                        'stOperador' => 'INTEGRACAO',
                        'stDocumento' => 'IFOOD',
                        'stTipoBaixa' => 'I',
                        'stTipoJuros' => 'P',
                        'vrDescontoLancamento' => 0,
                        'idContaBancaria' => 1,
                        'idConta' => $this->config->id_conta_financeiro,
                        'dtAlteracao' => Carbon::now(),
                    ]);
                }
            }


            $extrato = Extract::create([
                'idExtrato' => $this->nextId($sale->idAbertura),
                'idFatura' => 0,
                'idVenda' => $sale->idVenda,
                'idAbertura' => $sale->idAbertura,
                'idOperador' => $sale->idOperadorAutorizador,
                'idOperadorAutorizador' => $sale->idOperadorAutorizador,
                'idCliente' => $sale->idCliente,
                'dtData' => Carbon::now(),
                'vrTotal' => $sale->vrTotal,
                'vrDesconto' => $sale->vrDesconto,
                'vrAcrescimo' => $sale->vrAcrescimo,
                'vrSaldoAnterior' => 0,
                'vrQuitado' => 0,
                'flNotaFiscal' => false,
                'flAtivo' => true,
                'dtAlteracao' => Carbon::now(),
            ]);

            $itens = $sale->itens()->get();
            foreach ($itens as $iten) {
                $itemExtrato = new ItensExtract([
                    'idItem' => $iten->idItem,
                    'idExtrato' => $extrato->idExtrato,
                    'idAbertura' => $sale->idAbertura,
                    'idProduto' => $iten->idProduto,
                    'dtData' => $iten->dtData,
                    'nrQuantidade' => $iten->nrQuantidade,
                    'vrCusto' => $iten->vrCusto,
                    'vrUnitario' => $iten->vrUnitario,
                    'vrDesconto' => $iten->vrDesconto,
                    'flAtivo' => $iten->flAtivo,
                    'idComanda' => $iten->idComanda,
                    'vrTotal' => $iten->vrTotal,
                    'vrTotalCusto' => $iten->vrTotalCusto,
                    'flPago' => false,
                    'dtAlteracao' => Carbon::now(),
                ]);

                $extrato->itens()->save($itemExtrato);
            }

            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
        }

    }

    private function nextId($idAbertura)
    {
        return Extract::where('idAbertura', $idAbertura)
                ->max('idExtrato') + 1;
    }
}
