<?php


namespace App\Services;


use App\Entities\Comanda;
use App\Repositories\ComandaRepository;
use Carbon\Carbon;

class ComandaService
{
    protected $repository;

    public function __construct(ComandaRepository $repository)
    {
        $this->repository = $repository;
    }

    public function getComandas()
    {
        $comandas = Comanda::with('itens')
            ->where('flBloqueada', false)
            ->where('idMicroterminallock', '=', '')
            ->where('stOperadorlock', '=', '')
            ->where('dtAlteracao', '>=', Carbon::now()->subHours(4))
            ->get();

        return $comandas;
    }

}
