<?php


namespace App\Services\Delivery;


use App\Entities\Delivery\DlvConfig;
use App\Entities\Delivery\MonitorPreparo;
use App\Entities\Nati\Product;
use App\Services\Nati\ProductService;

class PainelPreparoService
{
    protected $deliveryConfig;
    protected $produtoService;

    public function __construct(ProductService $productService)
    {
        $conf = (object)app('config')->get('ifood');
        $this->produtoService = $productService;
        // $this->deliveryConfig = DlvConfig::find($conf->ponto_delivery_padrao);
    }

    public function add($order)
    {
        if (!$order) {
            throw new \Exception('Order not found');
        }

        $arr = [];

        foreach ($order->items as $item) {
            $fichas = $item->fichaTecnica->where('idMicroterminal', '=', $this->deliveryConfig->idMicroterminal);

            foreach ($fichas as $ficha) {
                if ($ficha) {
                    array_push($arr, ['idPrint' => $ficha->idPrint, 'items' => $item]);
                }
            }
        }
        $result = array();
        foreach ($arr as $element) {
            $result[$element['idPrint']][] = $element;
        }

        try {
            foreach ($result as $x) {
                $payload = [
                    'idAtendimento' => $order->idAtendimento,
                    'items' => []
                ];
                if (count($x) > 1) {
                    foreach ($x as $it) {
                        $payload['idPrint'] = $it['idPrint'];
                        array_push($payload['items'], $this->itemTransform($it['items']));
                    }
                    MonitorPreparo::create([
                        'idPrint' => $it['idPrint'],
                        'payload' => json_encode($payload),
                    ]);
                } else {
                    $payload['idPrint'] = $x[0]['idPrint'];
                    array_push($payload['items'], $this->itemTransform($x[0]['items']));
                    MonitorPreparo::create([
                        'idPrint' => $x[0]['idPrint'],
                        'payload' => json_encode($payload),
                    ]);
                }
            }
        } catch (\Exception $e) {
        }
    }

    public function itemTransform($rawItem)
    {
        $codigos = '';
        $subItems = [];
        $res = [
            'quantidade' => $rawItem->nrQuantidade,
            'descricao' => $rawItem->descricao,
            'observacao' => $rawItem->stOBS,
            'codigo' => $rawItem->codigo,
            'subItens' => []
        ];

        if (isset($rawItem->stCodigos) && strlen($rawItem->stCodigos) > 0) {
            $codigos = explode('@', $rawItem->stCodigos);
            $quantidades =explode('@', $rawItem->stQuantidades);

            for ($i = 0; $i < count($codigos); $i++) {
                $produto = Product::find($codigos[$i]);
                $item = [
                    'quantidade' => $quantidades[$i],
                    'descricao' => $produto->stProdutoAbreviado,
                    'codigo' => $codigos[$i]
                ];
                $res['subItens'][] = $item;
            }
        }

        return $res;
    }
}
