<?php

namespace App\Services\Nati;

use Carbon\Carbon;
use App\Services\Service;
use App\Entities\Nati\Product;
use App\Repositories\Nati\SubCategoriaRepository;
use App\Validators\Nati\SubCategoriaValidator;
use Prettus\Validator\Contracts\ValidatorInterface;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;
use App\Entities\Nati\SubCategoria;

class SubCategoriaService extends Service
{
    private $repository;
    private $validator;

    /**
     * CategoriaService constructor.
     * @param SubCategoriaRepository $repository
     * @param SubCategoriaValidator $validator
     */
    public function __construct(SubCategoriaRepository $repository, SubCategoriaValidator $validator)
    {
        $this->repository = $repository;
        $this->validator = $validator;
    }

    public function getById($id, $id_category)
    {
        $subCategoria = $this->repository->findWhere([
            'id' => $id,
            'id_category' => $id_category
        ])->first();

        if (!$subCategoria) {
            throw new BadRequestHttpException('Erro ao localizar subCategoria');
        }

        return $subCategoria;
    }

    public function all()
    {
        return $this->repository->all();
    }

    public function create($data)
    {
        $this->validator->with($data)->passesOrFail(ValidatorInterface::RULE_CREATE);

        $data = [
            'idSubCategoria' => $this->getNextId($data['idCategoria']),
            'idCategoria' => $data['idCategoria'],
            'stSubCategoria' => $data['stSubCategoria'],
            'dtAlteracao' => Carbon::now()
        ];

        return $categoria = $this->repository->create($data);
    }

    public function update($request, $id, $id_category)
    {
        $request['name'] = strtoupper($this->cleanString($request['name']));

        $this->validator->with($request)->passesOrFail(ValidatorInterface::RULE_UPDATE);

        return $this->repository->findWhere([
            'id' => $id,
            'id_category' => $id_category
        ])->first()->update($request);
    }

    public function atualizar($request, $id, $id_category)
    {
        $request['subCategoria']['stSubCategoria'] = strtoupper($this->cleanString($request['subCategoria']['stSubCategoria']));

        return $subCategoria = SubCategoria::where('idCategoria', $id_category)
                                    ->where('idSubCategoria', $id)
                                    ->update([
                                        'stSubCategoria' => $request['subCategoria']['newStSubCategoria'],
                                        'dtAlteracao' => Carbon::now()
                                    ]);
    }

    public function delete($idSubCategoria, $idCategoria)
    {
        $subCategoria = $this->repository->findWhere([
            'idSubCategoria' => $idSubCategoria,
            'idCategoria' => $idCategoria
        ])->first();

        if (!count($subCategoria)) {

            throw new BadRequestHttpException('Erro ao excluir subCategoria');

        } else {

            return $subCategoria->delete();
        }
    }

    public function getNextId($idCategoria)
    {
        if ($this->repository->all()->where('idCategoria', $idCategoria)->last()) {
            return $this->repository->all()->where('idCategoria', $idCategoria)->last()->idSubCategoria + 1;
        } else {
            return $idSubCategoria = 0;
        }
    }

    public function transfer($destiny, $id, $id_category)
    {
        $product = Product::where('idCategoria', $id_category)
            ->where('idSubCategoria', $id)
            ->update([
                'idCategoria' => $destiny['categoria'],
                'idSubCategoria' => $destiny['subcategoria']
            ]);

//        $this->repository->findWhere([
//            'id' => $id,
//            'id_category' => $id_category
//        ])->first()->delete();

        return $product;
    }

    public function getOrCreate($nameSubCategoria, $idCategoria)
    {
        $params['stSubCategoria'] = $nameSubCategoria;
        $params['idCategoria'] = $idCategoria;

        $subcategoria = $this->repository
                            ->where('stSubCategoria', strtoupper($params['stSubCategoria']))
                            ->where('idCategoria', $params['idCategoria'])
                            ->first();
        if($subcategoria){
            return $subcategoria;
        }else{
            $params['stSubCategoria'] = strtoupper($params['stSubCategoria']);
            return $this->create($params);
        }
    }
}
