<?php

namespace Database\Factories;

use App\Entities\Nati\Code;
use App\Entities\Nati\Product;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProductFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = Product::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'idProduto' => $this->faker->unique()->numberBetween(1, 100000),
            'stProduto' => 'COCA COLA LATA',
            'stProdutoAbreviado' => 'COCA COLA LATA',
            'stOperador' => 'ARCNET',
            'idCategoria' => 1,
            'idSetor' => 1,
            'idMedida' => 1,
            'idLocalizacao' => 1,
            'idAliquota' => 1,
            'vrUnitario' => 4.5,
            'vrCusto' => 2.5,
            'flComissao' => false,
            'nrValidade' => 30,
            'flAtivo' => true,
            'flControlarEstoque' => true,
            'stDescricao' => 'a',
            'idTipoProduto' => 1,
            'flPocket' => false,
            'idSubCategoria' => 1,
            'nr10Mais' => 0,
            'dtUltimaVenda' => \Carbon\Carbon::now(),
            'dtUltimaAlteracao' => \Carbon\Carbon::now(),
            'flPromocao' => false,
            'dtInicioPromocao' => \Carbon\Carbon::now(),
            'dtFimPromocao' => \Carbon\Carbon::now(),
            'vrUnitarioPromocao' => 4.5,
            'flVendaCartao' => false,
            'flVendaTicket' => false,
            'flVendaSmart' => false,
            'flRequererItemAdicional' => false,
            'vrMargemLucro' => 100,
            'flBalanca' => false,
            'idMedidaCompra' => 1,
            'nrFatorConversao' => 1,
            'dtUltimaCompra' => \Carbon\Carbon::now(),
            'dtAlteracao' => \Carbon\Carbon::now(),
            'nrTipoProduto' => 1,
            'idProdutoVinculado' => 0,
            'vrUnitario2' => 4.5,
            'flCupomPreVenda' => false,
            'idProdutoIntegracao' => 0,
            'dtCriacao' => \Carbon\Carbon::now(),
            'flDesconto' => false,
            'nrNCM' => '19059090',
            'flPromocaoHora' => false,
            'dtInicioPromocaoHora' => \Carbon\Carbon::now(),
            'dtFimPromocaoHora' => \Carbon\Carbon::now(),
            'vrUnitarioPromocaoHora' => 5.5,
            'stCest' => '1234567',
            // 'medida' => '1',
            // 'setor' => 1,
            // 'aliquota' => 1,
            'flRevisaoTributaria' => false,
            // 'categoria' => 1,
            // 'subcategoria' => 1,
            // 'ficha' => 1
        ];
    }

    public function configure()
    {
        return $this->afterCreating(function (Product $product) {
            Code::factory()->create(
                [
                    'idProduto' => $product->idProduto,
                ]
            );
        });
    }
}
