<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateCxGerenciadorDetalhesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('cx_GerenciadorDetalhes')) {
            Schema::create('cx_GerenciadorDetalhes', function (Blueprint $table) {
                $table->integer('idAbertura', false, true);
                $table->integer('idFormaPagamento', false, true);
                $table->integer('idDetalhe', false, true);
                $table->decimal('vrPagamento', 9, 2);
                $table->integer('idOperador', false, true);
                $table->decimal('vrPagamentoMicro', 9, 2);
                $table->boolean('flPendente')->default(true);
                $table->dateTime('dtAlteracao')->default(\Carbon\Carbon::now());

            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cx_GerenciadorDetalhes');
    }
}
