<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstInventarioItensTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_Inventario_Itens')) {

            Schema::create('est_Inventario_Itens', function (Blueprint $table) {

                $table->unsignedInteger('idInventario', false);
                $table->unsignedInteger('idItem', false);
                $table->unsignedInteger('idProduto', false);
                $table->decimal('nrEstoqueAtual1', 15, 3);
                $table->decimal('nrEstoqueAtual2', 15, 3);
                $table->decimal('nrEstoqueAtual3', 15, 3);
                $table->decimal('nrContagem1', 15, 3);
                $table->decimal('nrContagem2', 15, 3);
                $table->decimal('nrContagem3', 15, 3);
                $table->boolean('flContagem1');
                $table->boolean('flContagem2');
                $table->boolean('flContagem3');
                $table->dateTime('dtContagem1');
                $table->dateTime('dtContagem2');
                $table->dateTime('dtContagem3');
                $table->dateTime('dtAlteracao');

                $table->primary(['idInventario', 'idItem']);

            });

        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_Inventario_Itens');
    }
}

