<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterVwNatiProdutos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $nameView = "vw_nati_produtos";
        DB::statement($this->dropView($nameView));

        DB::statement("
                CREATE view vw_nati_produtos as
                select p.idProduto as 'id',
                case when P.flAtivo = 0  and c.idcodigo is null then '0000000000000' else REPLICATE('0', 13-LEN(C.idCodigo)) + c.idCodigo end as codigo,
                p.stProdutoAbreviado as descricao,
                case
                    when (p.flPromocao = '1' and GETDATE() BETWEEN p.dtInicioPromocao and p.dtFimPromocao) then p.vrUnitarioPromocao
                    when (
                            p.flPromocaoHora = '1' and DATEPART(HOUR, GETDATE()) >= DATEPART(HOUR, p.dtInicioPromocaoHora) and DATEPART(MINUTE, GETDATE()) >= DATEPART(MINUTE, p.dtInicioPromocaoHora)
                            and DATEPART(HOUR, GETDATE()) <= DATEPART(HOUR, p.dtFimPromocaoHora) and DATEPART(MINUTE, GETDATE()) <= DATEPART(MINUTE, p.dtFimPromocaoHora)
                        )then p.vrUnitarioPromocaoHora
                        else p.vrUnitario
                    end as preco,
                    p.vrCusto as custo,
                CASE when m.flFracionado = '1' then 'KG'
                ELSE 'UN' end as medida,
                CASE
                when m.flFracionado = '1' then Convert(bit, '1')
                else Convert(bit, '0')
                end as kilo,
                CASE
                when p.idTipoProduto = '3' then Convert(bit, '1')
                else Convert(bit, '0')
                end as pizza,
                CASE
                when p.idTipoProduto = '2' then Convert(bit, '1')
                else Convert(bit, '0')
                end as requerValor,
                p.nrNCM as ncm,
                p.stCest as cest,
                p.flDesconto as permiteDesconto,
                p.flComissao as permiteAcrescimo,
                a.stAliquota as 'aliquota',
                a.CfopSaida as cfop,
                a.cstIcms,
                a.aliquotaIcms,
                a.cstPis,
                a.aliquotaPis,
                a.idAliquota,
                a.cstCofins,
                a.aliquotaCofins,
                p.idCategoria,
                cat.stCategoria as 'categoria',
                p.idSubCategoria,
                sc.stSubCategoria as 'subcategoria',
                p.idSetor,
                s.stSetor as 'setor',
                p.dtUltimaAlteracao as 'alteracao',
                p.flAtivo as 'ativo'
                from prd_Codigos c
                right join prd_Produtos  P on p.idProduto  = c.idProduto
                inner join prd_Medidas   M on m.idMedida   = p.idMedida
                inner join prd_Aliquotas A on a.idAliquota = p.idAliquota
                inner join prd_Categorias Cat on cat.idCategoria = p.idCategoria
                inner join prd_SubCategorias SC on SC.idSubCategoria = p.idSubCategoria and p.idCategoria = sc.idCategoria
                inner join prd_Setores S on s.idSetor = p.idSetor
                group by
                p.idProduto,
                c.idCodigo,
                p.stProdutoAbreviado,
                p.flPromocao,
                p.vrUnitarioPromocaoHora,
                p.vrUnitario,
                p.vrCusto,
                p.dtInicioPromocao,
                p.dtFimPromocao,
                p.vrUnitarioPromocao,
                p.flPromocaoHora,
                p.dtInicioPromocaoHora,
                p.dtFimPromocaoHora,
                m.flFracionado,
                p.idTipoProduto,
                p.nrNCM,
                p.stCest,
                p.flDesconto,
                p.flComissao,
                a.CfopSaida,
                a.cstIcms,
                a.aliquotaIcms,
                a.cstPis,
                a.aliquotaPis,
                a.idAliquota,
                a.cstCofins,
                a.aliquotaCofins,
                cat.stCategoria,
                p.idCategoria,
                p.idSubCategoria,
                sc.stSubCategoria,
                p.idSetor,
                s.stSetor,
                p.dtUltimaAlteracao,
                p.flAtivo,
                a.stAliquota
        ");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }

    private function dropView($nameView)
    {
        return "if exists(select 1 from sys.views where name= '" . $nameView . "' and type='v')
                drop view " . $nameView . ";";
    }
}
