<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateMsgUsuarioEventos extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if(!Schema::hasTable('msg_usuarioEventos')) {
            Schema::create('msg_usuarioEventos', function (Blueprint $table) {
                $table->bigInteger('idUsuario');
                $table->bigInteger('idEvento');

                $table->primary(['idUsuario', 'idEvento']);
                $table->foreign('idUsuario')->references('id')->on('msg_usuarios');
                $table->foreign('idEvento')->references('id')->on('msg_eventos');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('msg_usuario_eventos');
    }
}
