<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateEstItensMovimentacaoTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('est_ItensMovimentacao')) {
            Schema::create("est_ItensMovimentacao", function (Blueprint $table) {
                $table->integer('idItem');
                $table->bigInteger('idMovimentacao');
                $table->integer('idAbertura');
                $table->integer('idProduto');
                $table->decimal('nrQuantidade', 10, 3);
                $table->decimal('vrValor', 10, 3);
                $table->integer('nrQuantidadeConversao');
                $table->string('stMedidaConversao', 20);
                $table->dateTime('dtAlteracao');
            });
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('est_ItensMovimentacao');
    }
}
