<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateFinContasReceberTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!Schema::hasTable('fin_ContasReceber')) {

            DB::statement('CREATE TABLE [dbo].[fin_ContasReceber](
                  [idContasReceber] [int] NOT NULL,
                  [idCliente] [int] NOT NULL,
                  [idTipoConta] [smallint] NOT NULL CONSTRAINT [DF_fin_ContasReceber_idTipoConta]  DEFAULT ((1)),
                  [dtLancamento] [datetime] NOT NULL,
                  [dtVencimento] [datetime] NOT NULL,
                  [dtRecebimento] [datetime] NULL,
                  [nrParcela] [smallint] NOT NULL,
                  [nrTotalParcelas] [smallint] NOT NULL,
                  [vrDocumento] [decimal](9, 2) NOT NULL,
                  [vrRecebido] [decimal](9, 2) NOT NULL CONSTRAINT [DF_fin_ContasReceber_vrRecebido]  DEFAULT ((0)),
                  [vrJuros] [decimal](9, 2) NOT NULL CONSTRAINT [DF_fin_ContasReceber_vrJuros]  DEFAULT ((0)),
                  [flJuros] [bit] NULL,
                  [flRecebido] [bit] NOT NULL CONSTRAINT [DF_fin_ContasReceber_flRecebido]  DEFAULT ((0)),
                  [flAtivo] [bit] NOT NULL CONSTRAINT [DF_fin_ContasReceber_flAtivo]  DEFAULT ((1)),
                  [stOperador] [nvarchar](20) NOT NULL,
                  [stObservacao] [nvarchar](255) NULL,
                  [stDocumento] [nvarchar](50) NOT NULL,
                  [stTipoBaixa] [nvarchar](1) NOT NULL CONSTRAINT [DF_fin_ContasReceber_stTipoBaixa]  DEFAULT (N\'I\'),
                  [stTipoJuros] [nvarchar](1) NOT NULL CONSTRAINT [DF_fin_ContasReceber_stTipoJuros]  DEFAULT (N\'P\'),
                  [idFormaPagamento] [smallint] NULL,
                  [stObservacaoBaixa] [nvarchar](255) NULL,
                  [vrDescontoLancamento] [decimal](9, 2) NOT NULL CONSTRAINT [DF_fin_ContasReceber_vrDescontoLancamento]  DEFAULT ((0)),
                  [idContaBancaria] [smallint] NOT NULL CONSTRAINT [DF_fin_ContasReceber_idContaBancaria]  DEFAULT ((0)),
                  [idConta] [smallint] NOT NULL CONSTRAINT [DF_fin_ContasReceber_idConta]  DEFAULT ((0)),
                  [dtAlteracao] [datetime] NOT NULL CONSTRAINT [DF_fin_ContasReceber_dtAlteracao]  DEFAULT (getdate()),
                  [idTipoPagamento] [smallint] NULL CONSTRAINT [DF_fin_ContasReceber_idTipoPagamento]  DEFAULT ((1)),
                  [stFormato] [nvarchar](1) NULL,
                  CONSTRAINT [PK_fin_ContasReceber] PRIMARY KEY CLUSTERED
                    (
                      [idContasReceber] ASC,
                      [idCliente] ASC
                    )WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
                ) ON [PRIMARY]');
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('fin_ContasReceber');
    }
}
