function numbersOnly(e) {
    if (e.which != 8 && e.which != 0 && (e.which < 48 || e.which > 57)) {
        return false;
    }
}

function cpfCnpjDigits(field) {
    var maskBehavior = function (val) {
            return val.replace(/\D/g, '').length >= 12 ? '00.000.000/0000-00' : '000.000.000-009';
        },
        options = {
            onKeyPress: function (val, e, field, options) {
                field.mask(maskBehavior.apply({}, arguments), options);
            }
        };

    $('input[name=' + field + ']').mask(maskBehavior, options);
}

function initializeMaskedEdit() {
    var inputs = $('input[onKeyPress]');
    for (var i = 0; i < inputs.length; i++) {
        if ($('input[name=' + inputs[i].name + ']').val().length > 1) {
            $('input[name=' + inputs[i].name + ']').keypress();
        }
    }
    ;
}

function setMoneyFormat(input, evento, total) {
    if (input.value.length < 10 || evento.keyCode === 8 || evento.keyCode === 46 || evento.keyCode === 9 || evento.keyCode === 43 || evento.keyCode === 45 || evento.keyCode === 107 || evento.keyCode === 109) {
        if ((evento.keyCode >= 48 && evento.keyCode <= 57) || (evento.keyCode >= 96 && evento.keyCode <= 105) || evento.keyCode === 8 || evento.keyCode === 46 || evento.keyCode === 43 || evento.keyCode === 45 || evento.keyCode === 107 || evento.keyCode === 109) {
            var result = "";

            switch (evento.keyCode) {
                case evento.keyCode = 45 :
                case evento.keyCode = 109 :
                    if (input.value.substring(0, 1) !== '-') {
                        result = "-" + input.value;
                        break;
                    }
                    else {
                        evento.returnValue = false;
                        return false;
                    }
                case evento.keyCode = 43 :
                case evento.keyCode = 107 :
                    if (input.value.substring(0, 1) === '-') {
                        result = input.value.substring(1, input.value.length);
                        break;
                    }
                    else {
                        evento.returnValue = false;
                        return false;
                    }
                case evento.keyCode = 8 :
                case evento.keyCode = 46 :
                    result = input.value.substring(0, (input.value.length - 1));
                    break;
                case evento.keyCode = 48 :
                case evento.keyCode = 96 :
                    result = input.value + "0";
                    break;
                case evento.keyCode = 49 :
                case evento.keyCode = 97 :
                    result = input.value + "1";
                    break;
                case evento.keyCode = 50 :
                case evento.keyCode = 98 :
                    result = input.value + "2";
                    break;
                case evento.keyCode = 51 :
                case evento.keyCode = 99 :
                    result = input.value + "3";
                    break;
                case evento.keyCode = 52 :
                case evento.keyCode = 100 :
                    result = input.value + "4";
                    break;
                case evento.keyCode = 53 :
                case evento.keyCode = 101 :
                    result = input.value + "5";
                    break;
                case evento.keyCode = 54 :
                case evento.keyCode = 102 :
                    result = input.value + "6";
                    break;
                case evento.keyCode = 55 :
                case evento.keyCode = 103 :
                    result = input.value + "7";
                    break;
                case evento.keyCode = 56 :
                case evento.keyCode = 104 :
                    result = input.value + "8";
                    break;
                case evento.keyCode = 57 :
                case evento.keyCode = 105 :
                    result = input.value + "9";
                    break;
            }

            result = result.replace(",", "");

            while (result.substring(0, 1) === "0") {
                result = result.substring(1, result.length);
            }

            if (result.length > 0) {
                if (result.length === 1) {
                    var end = result;

                    var r = "0,0" + end;
                }
                else if (result.length === 2) {
                    var end = result;

                    var r = "0," + end;
                }
                else if (result.length >= 3) {
                    var ini = result.substring(0, (result.length - 2));
                    var end = result.substring(result.length - 2);

                    var r = ini + "," + end;
                }

                result = r;
                input.value = result;
            }
            else {
                input.value = "0,00";
            }
        }
        else if (evento.keyCode === 9)
            return evento.keyCode;

        try {
            somarValores(input.name, total);
        } catch (ex) {
        }
    }
    evento.returnValue = false;
    return false;
}

function openModal(target) {
    switch (target) {
        case 'procurarCEP':
            $.post('resources/php/cliente_functions.php', {action: 'getCidadePadrao'}, function (response) {
                $('#stCidadeEscolha').val(response.stCidade);
                $('#procurarCEP').modal('show');
            });
            break;
        case 'cadCEP':
            $('#cadastroCEP').modal('show');
            break;
    }
};

$("#cadastraCEP").on('submit', function (e) {
    e.preventDefault();
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }
    $.post('resources/php/cliente_functions.php', $("#cadastraCEP").serialize(), function (response) {
        if (response.status) {
            $("#stCEP").val($("#stCEPCadastro").val());
            $("#stEstado").val($("#stEstadoCadastro").val());
            $("#stEndereco").val($("#stEnderecoCadastro").val());
            $("#stCidade").val($("#stCidadeCadastro").val());
            $("#stBairro").val($("#stBairroCadastro").val());
            $('#cadastroCEP').modal('hide');
        } else {
            toastr.error(response.msg);
            $('#cadastroCEP').modal('hide');
        }
        $("#stCEPCadastro").val("");
        $("#stEstadoCadastro").val("");
        $("#stEnderecoCadastro").val("");
        $("#stCidadeCadastro").val("");
        $("#stBairroCadastro").val("");
    });
});

$("#procuraCEP").on('submit', function (e) {
    e.preventDefault();
    var cidade = $("#stCidadeEscolha").val().replace(/_/g, " ");
    var rua = $('#stRuaEscolha').val();
    var data = {action: "getDataByStreet", stCidadeEscolha: cidade, stRuaEscolha: rua};
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }
    $.post('resources/php/cliente_functions.php', data, function (response) {
        var linhas = "";
        if (response.length > 0) {
            for (var i = 0; i < response.length; i++) {
                $('#selectRuas').append($("<option></option>").attr("value", response[i]).text(response[++i]));
            }
        } else {
            $('#selectRuas').append($("<option></option>").attr("value", "0").text("Nenhum endereço encontrado"));
        }
        $('#procurarCEP').modal('hide');
        $('#escolherEndereco').modal('show');
    });
});

$("#escolherEndereco").on('submit', function (e) {
    e.preventDefault();
    var id = $("#selectRuas").val();
    var data = {action: 'getDataByCepId', idCep: id};
    $.post('resources/php/cliente_functions.php', data, function (response) {
        $('#escolherEndereco').modal('hide');
        $("#stCEP").val(response.stCEP);
        $("#stEndereco").val(response.stEndereco);
        $("#stBairro").val(response.stBairro);
        $("#stCidade").val(response.stCidade);
        $("#stEstado").val(response.stEstado);
        $("#idCEP").val(response.idCEP);
    });

    $('#selectRuas').remove();
    $('#selectDiv').append($("<select size='10' class='form-control' id='selectRuas'> </select>"))
});

$("#cadastroClientes").on('submit', function (e) {
    e.preventDefault();
    toastr.options =
        {
            "positionClass": "toast-bottom-right"
        }
    $("#btnSalvar").attr("disabled", true);

    $("body").addClass("loading");
    $.post('resources/php/cliente_functions.php', $("#cadastroClientes").serialize(), function (response) {
        $("body").removeClass("loading");
        if (response.status === true) {
            toastr.success(response.msg);
            setTimeout(function () {
                document.location = response.location
            }, response.time);
        }
        else {
            toastr.error(response.msg);
            $("#btnSalvar").attr("disabled", false);
        }
    });
});

function getEndereco() {
    toastr.options =
        {
            "timeOut": "1000",
            "positionClass": "toast-bottom-right"
        }
    var cep = $("#stCEP").val();
    toastr.info("Buscando CEP, Aguarde...");
    var data = {action: 'getDataByCep', stCEP: cep};
    $.post('resources/php/cliente_functions.php', data, function (response) {
        if (response) {
            toastr.success("CEP encontrado");
            $("#stCEP").val(response.stCEP);
            $("#stEndereco").val(response.stEndereco);
            $("#stBairro").val(response.stBairro);
            $("#stCidade").val(response.stCidade);
            $("#stEstado").val(response.stEstado);
            $("#idCEP").val(response.idCEP);
        } else {
            toastr.error("CEP não encontrado");
            $("#stEndereco").val("");
            $("#stBairro").val("");
            $("#stCidade").val("");
            $("#stEstado").val("");
            $("#idCEP").val("");
        }
    });
}

function checkPhones() {
    toastr.options =
        {
            "timeOut": "1000",
            "positionClass": "toast-bottom-right"
        }

    if ($('#nrTelefone').val() != "") {
        $('#nrDDD').attr('required', '');
        $('#nrTelefone').attr('required', '');
        $('#nrDDD2').removeAttr('required');
        $('#nrTelefone2').removeAttr('required');
    } else {
        $('#nrDDD').removeAttr('required');
        $('#nrTelefone').removeAttr('required');
        $('#nrDDD2').attr('required', '');
        $('#nrTelefone2').attr('required', '');
    }

    if ($('#nrTelefone').val() == $('#nrTelefone2').val()) {
        console.log($('#nrTelefone'));
        $('#divTelefone1').addClass("has-error");
        $('#divTelefone2').addClass("has-error");
        toastr.error("Os números de telefone não podem ser iguais");
    } else {
        $('#divTelefone1').removeClass("has-error");
        $('#divTelefone2').removeClass("has-error");
    }
}

document.addEventListener("DOMContentLoaded", function () {
    var pagina = $("#idPagina").val();
    if (pagina === "listagemCliente") {
        getClientes();
    }
});

function deleteCliente(id) {
    toastr.options = {"positionClass": "toast-bottom-right"};
    $("body").addClass("loading");
    var data = {
        action: 'deleteCliente',
        idCliente: id
    };
    swal({
        title: 'Tem certeza?',
        text: 'Esta ação não poderá ser revertida!',
        type: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Sim, remover',
        cancelButtonText: 'Cancelar',
    }).then((result) => {
        if (result.value) {

            $.post('resources/php/cliente_functions.php', data)
                .success(function () {
                    swal('Deletado', 'Cliente removido com sucesso', 'success');
                })
                .error(function () {
                    swal('Erro', 'Erro ao remover cliente', 'error');
                })
                .done(function () {
                    $('#listagem_clientes').DataTable().ajax.reload();
                });

        } else if (result.dismiss === 'cancel') {
            swal(
                'Cancelado',
                'Cliente não deletado',
                'error'
            )
        }

    })
}

function getClientes() {

    $('#listagem_clientes').DataTable({
        searching: true,
        paging: true,
        info: true,
        deferRender: true,
        processing: true,
        serverSide: true,
        "bDeferRender": true,
        "stateSave": true,
        ajax: "/api/delivery/v1/clientes",
        columns: [
            {data: "idCliente", name: "idCliente"},
            {data: "stCliente", name: "stCliente"},
            {
                data: "nrTelefone", name: "nrTelefone", render: function (data) {
                    if (data) {
                        return data
                    } else {
                        return 'SEM NÚMERO'
                    }
                }
            },
            {
                data: "flBloqueado", name: "flBloqueado",
                render: function (data) {
                    if (data === "1") return "SIM";
                    else return "NÃO";
                }
            },
            {
                data: "flContaAssinada", name: "flContaAssinada",
                render: function (data) {
                    if (data === "1") return "SIM";
                    else return "NÃO";
                }
            },

            {
                data: null, orderable: false, searchable: false, render: function (data) {

                    return '<a  href="?sec=cadastroClientes&id=' + data.idCliente + '" style="cursor:pointer"><span style="font-size:14px" class="glyphicon glyphicon-edit col-md-6" align="center" title="Editar"></span></a>' +
                        '<a class="tdStyle" onclick="deleteCliente(' + data.idCliente + ')" style="cursor:pointer"><span style="font-size:14px" class="glyphicon glyphicon-remove col-md-6" align="center" title="Desativar"></span></a>';
                }
            }
        ],
        language: {url: "resources/js/Portuguese-Brasil.json"}
    });
}
