<?php
header('Content-type: application/json');

chdir(dirname(realpath(__FILE__)));
require_once "../../../functions.php";
require_once "../../../database/models/CxCaixaLoginClose.class.php";
db_conn();

cx_Itens = "cx_FichaRecebimentos";
cx_Vendas = "cx_Itens";
cx_FichaPagamentos = "cx_Vendas";

if (isset($_POST['action'])) {
	switch ($_POST['action']) {
		case 'getLocais':
		getLocais();
		break;
		case 'excluirLocal':
		excluirLocal($_POST['idLocal']);
		break;
		case 'cadastrarLocal':
		cadastrarLocal($_POST['stLocal']);
		break;
		case 'editarLocal':
		editarLocal($_POST['idLocal'], $_POST['stLocal']);
		break;
		case 'getSetores':
		getSetores();
		break;
		case 'excluirSetor':
		excluirSetor($_POST['idSetor']);
		break;
		case 'cadastrarSetor':
		cadastrarSetor($_POST['stSetor'], $_POST['nrInicio'], $_POST['nrFim']);
		break;
		case 'editarSetor':
		editarSetor($_POST['idSetor'], $_POST['stSetor']);
		break;
		case 'getReserva':
		getReserva();
		break;
	}
}

function retornaJson($status, $message, $location="", $time=0){

	$response_array['status'] = $status;
	$response_array['msg'] = $message;

	if ($status)
	{
		$response_array['location'] = $location;
		$response_array['time'] = $time;
	}

	return json_encode($response_array);
}

function getLocais()
{
	$qry = "SELECT * FROM prd_Localizacoes WHERE flAtivo = '1' ORDER BY stLocalizacao ASC";

	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		$arr['stLocalizacao'] = utf8_encode($arr['stLocalizacao']);
		$result[] = $arr;
	}
	echo json_encode($result);
}

function excluirLocal($idLocal){
	$qry = "UPDATE prd_Localizacoes SET flAtivo = 0 WHERE idLocalizacao=". $idLocal;
	$res = mssql_query($qry);
	if ($res) {
		echo retornaJson(true, 'Localização excluida com sucesso.');
	}else{
		echo retornaJson(false, 'Erro ao excluir a localização.');
	}
}
function cadastrarLocal($stLocal){
	$qry = 'SELECT MAX(idLocalizacao) as idLocalizacao FROM prd_Localizacoes';
	$res = mssql_query($qry);
	$idLocalizacao = (mssql_fetch_array($res)[0] + 1);
	$qry = "INSERT INTO prd_Localizacoes VALUES(". $idLocalizacao .",'". $stLocal ."',1,GETDATE())";
	$res = mssql_query($qry);
	if ($res) {
		echo retornaJson(true, 'Cadastrado com sucesso, recarregando a página.');
	}else{
		echo retornaJson(false, 'Erro ao cadastrar.');
	}
}
function editarLocal($idLocal, $stLocal){
	$qry = "UPDATE prd_Localizacoes SET stLocalizacao='".$stLocal."', dtAlteracao=GETDATE() WHERE idLocalizacao=". $idLocal;
	$res = mssql_query($qry);
	if ($res) {
		echo retornaJson(true, 'Localização alterada com sucesso.');
	}else{
		echo retornaJson(false, 'Erro ao editar a localização.');
	}
}

function getSetores()
{
	$qry = "SELECT * FROM prd_Setores WHERE flAtivo = '1' ORDER BY stSetor ASC";

	$res = mssql_query($qry);
	while ($arr = mssql_fetch_assoc($res)) {
		$qryP = "SELECT COUNT(*) FROM prd_Produtos where idSetor = '".$arr['idSetor']."'";
		$resP = mssql_query($qryP);
		$arrP = mssql_fetch_array($resP)[0];
		$arr['nrProdutos'] = $arrP;
		$result[] = $arr;
	}
	echo json_encode($result);
}

function excluirSetor($idSetor){
	$qry = "UPDATE prd_Setores SET flAtivo = '0', stReservaCodigosInicio = NULL, stReservaCodigosFim = NULL WHERE idSetor =". $idSetor;
	$res = mssql_query($qry);
	if ($res) {
		echo retornaJson(true, 'Setor excluido com sucesso.');
	}else{
		echo retornaJson(false, 'Erro ao excluir o Setor.');
	}
}
function cadastrarSetor($stSetor, $nrInicio, $nrFim){
	$qry = 'SELECT MAX(idSetor) as idSetor FROM prd_Setores';
	$res = mssql_query($qry);
	$idSetor = (mssql_fetch_array($res)[0] + 1);
	$qry = "INSERT INTO prd_Setores VALUES(". $idSetor .",'". $stSetor ."',1,GETDATE(),".$nrInicio.",".$nrFim.")";
	$res = mssql_query($qry);
	if ($res) {
		echo retornaJson(true, 'Cadastrado com sucesso, recarregando a página.');
	}else{
		echo retornaJson(false, 'Erro ao cadastrar.');
	}
}
function editarSetor($idSetor, $stSetor){
	$qry = "UPDATE prd_Setores SET stSetor='".$stSetor."', dtAlteracao=GETDATE() WHERE idSetor=". $idSetor;
	$res = mssql_query($qry);
	if ($res) {
		echo retornaJson(true, 'Setor alterado com sucesso.');
	}else{
		echo retornaJson(false, 'Erro ao editar o Setor.');
	}
}

function getReserva(){
	$qry = "SELECT stReservaCodigosInicio, stReservaCodigosFim FROM prd_Setores";
	for ($i = 10; $i < 100 ; $i++) {
		$valid = true;
		$res = mssql_query($qry);
		while ($arr = mssql_fetch_assoc($res)) {
			if ($arr['stReservaCodigosInicio'] == $i) {
				$valid = false;
			}
		}
		if ($valid) {
			$disponiveis[] = $i;
		}
	}
	echo json_encode($disponiveis);
}
?>
