<?php

/**
 * Description of Conexao
 *
 * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
 * 
 */

class Conexao {
    
    private $_engine = "";//mssql, mysql ou pgsql
    private $_host = "";
    private $_port = "";
    private $_user = "";
    private $_pass = "";
    private $_dbname = "";
    private $_objConexao = null;
    private $_db_conexao = null;
    private $_msg;
    
    private function setDadosConexao(){
        $path = str_replace("\\", "/", __FILE__);
        $root = str_replace("/database/models/Conexao.class.php", "", $path);
        $dadosConexao = file_get_contents($root.'/secrets.php');
        $DADOS = explode("$", $dadosConexao);
        $CON = array();

        foreach($DADOS as $str) :
            if(substr($str, 0, 2) != "<?") :
                $CON[] = substr($str, strpos($str, '"') + 1, (strrpos($str, '"') - (strpos($str, '"') + 1)));
            endif;    
        endforeach;
        
        $this->_host = "".$CON[0]."";
        $this->_user = "".$CON[1]."";
        $this->_pass = "".$CON[2]."";
        $this->_dbname = "".$CON[3]."";
    }

    
    protected function getMessage(){
        return $this->_msg;
    }

    private function abrir(){
        try{
            $this->setDadosConexao();
            ini_set('mssql.charset', 'UTF-8');
            $this->_objConexao = mssql_connect($this->_host,$this->_user,$this->_pass) or die("ERROR - Erro ao tentar conectar a base de dados: " . mssql_get_last_message());
            $this->_db_conexao = mssql_select_db($this->_dbname, $this->_objConexao) or die ("ERROR - Erro ao selecionar base de dados: " . mssql_get_last_message());
            ini_set('mssql.charset', 'UTF-8');

        }catch(Exception $ex){
            $this->_msg = "FATAL ERROR - Erro ao tentar se conectar com a base de dados: " . $ex->getMessage();
            $this->_objConexao = null;
        }
    }
    
    /**
     * @author Eduardo Santos Jr. - Duardaum <eduardo.santos@sistemanati.com.br>
     * @param string $SQL Passar uma query em forma de String para ser executado no banco de dados
     * @param array $SQL Passar um array com varias querys para ser executado no banco de dados
     * @access Elemento de acesso protegido
     * @return false Caso n�o obtenha sucesso, retorna um false
     * @return Statment Caso tenha sucesso, ele retorna um PDOStatment
     */
    protected function executar($SQL){
        try{
            self::abrir();
            if(is_array($SQL)){
                foreach($SQL as $qry){
                    if(!empty($qry)) :
                        $objSource = self::execQry($qry);
                    endif;
                }
            }else{
                $objSource = self::execQry($SQL);
            }
            //self::fechar();
            return $objSource;
        }catch(PDOException $ex){
            self::fechar();
            $this->_msg = "FATAL ERROR - erro ao tentar executar query na base de dados: " + $ex->getMessage();
            return false;
        }
    }

    private function execQry($sql){
        try{
            $objSource = mssql_query($sql, $this->_objConexao) or new Exception("Erro ao tentar executar Query na base de dados:  " . mssql_get_last_message());
            return $objSource;
        }catch(Exception $ex){
            $this->_msg = "ERROR - Erro ao tentar executar query na base de dados: " . $ex->getMessage() . $sql;
            throw(new Exception($this->_msg));
            return false;
        }
    }

    
    private function fechar(){
        mssql_close($this->_objConexao);
    }
    
}