
<?

function grafico($individual, $acumulado)
{
	$title = "Diagrama de Pareto (Curva ABC)";
	$legendaX = "GRUPOS DE PRODUTOS";
	$legendaY = "% DE VENDAS";
	
	header ("Content-type: image/gif");
	
	$img = @imagecreate(700, 300) or die("Cannot Initialize new GD image stream"); // cria a imagem
	
	$white = imagecolorallocate($img, 255, 255, 255);
	$black = imagecolorallocate($img, 0, 0, 0);
	$red = imagecolorallocate($img, 255, 0, 0);
	$green = imagecolorallocate($img, 0, 255, 0);
	$blue = imagecolorallocate($img, 0, 0, 255);
	$gray = imagecolorallocate($img, 200, 200, 200);
	
	imagerectangle($img, 0, 0, 699, 299, $black); // borda
	imagestring($img, 5, 120, 10,  $title, $black); // titulo
	imageline($img, 50, 50, 50, 255, $black); // eixo y
	imageline($img, 45, 250, 455, 250, $black); // eixo x
	
	for ($x=50; $x<270; $x+=20)
	{
		imageline($img, 45, $x, 455, $x, $black); // separações percentuais
		imagestring($img, 2, 20, ($x - 7),  (((($x - 50) / 2) - 100) * (-1)), $black); // legendas percentuais
	}
	
	for ($x=50; $x<450; $x+=135)
	{
		imageline($img, $x, 250, $x, 255, $black); // separações abc
	}
	
	imagestring($img, 2, 117, 255,  "A", $black); // legenda A
	imagestring($img, 2, 252, 255,  "B", $black); // legenda B
	imagestring($img, 2, 387, 255,  "C", $black); // legenda C
	
	imagefilledrectangle($img, 90, 249 - ((200 * $individual[0]) / 100), 145, 249, $blue); // barra A
	imagefilledrectangle($img, 225, 249 - ((200 * $individual[1]) / 100), 280, 249, $blue); // barra B
	imagefilledrectangle($img, 360, 249 - ((200 * $individual[2]) / 100), 415, 249, $blue); // barra C
	
	for ($x=248; $x<=250; $x++)
	{
		imageline($img, 117, $x - ((200 * $acumulado[0]) / 100), 252, $x - ((200 * $acumulado[1]) / 100), $red); // linha A - B
	}
	
	for ($x=248; $x<=250; $x++)
	{
		imageline($img, 252, $x - ((200 * $acumulado[1]) / 100), 387, $x - ((200 * $acumulado[2]) / 100), $red); // linha B - C
	}
	
	imagefilledellipse($img, 117, 249 - ((200 * $acumulado[0]) / 100), 10, 10, $red); // circulo A
	imagefilledellipse($img, 252, 249 - ((200 * $acumulado[1]) / 100), 10, 10, $red); // circulo B
	imagefilledellipse($img, 387, 249 - ((200 * $acumulado[2]) / 100), 10, 10, $red); // circulo C
	
	imagestring($img, 3, 190, 275,  $legendaX, $black); // legenda eixo y
	
	for ($x=0; $x<=strlen($legendaY); $x++)
	{
		imagestring($img, 3, 475, (10 * $x) + 95, $legendaY[$x], $black); // legenda eixo x
	}
	
	// retangulo valores
	imagefilledrectangle($img, 500, 50, 680, 70, $gray);
	imagerectangle($img, 500, 50, 680, 130, $black);

	imageline($img, 500, 70, 680, 70, $black);
	imageline($img, 500, 90, 680, 90, $black);
	imageline($img, 500, 110, 680, 110, $black);
	imageline($img, 500, 130, 680, 130, $black);
	
	imageline($img, 520, 50, 520, 130, $black);
	imageline($img, 600, 50, 600, 130, $black);
	
	imagestring($img, 3, 545, 54, "Total", $black);
	imagestring($img, 3, 610, 54, "Acumulado", $black);
	
	imagestring($img, 3, 507, 74, "A", $black);
	imagestring($img, 3, 507, 94, "B", $black);
	imagestring($img, 3, 507, 114, "C", $black);
	
	imagestring($img, 2, 535, 74, $individual[0]." %", $black);
	imagestring($img, 2, 535, 94, $individual[1]." %", $black);
	imagestring($img, 2, 535, 114, $individual[2]." %", $black);

	imagestring($img, 2, 615, 74, $acumulado[0]." %", $black);
	imagestring($img, 2, 615, 94, $acumulado[1]." %", $black);
	imagestring($img, 2, 615, 114, $acumulado[2]." %", $black);
	// fim do retangulo
	
	// retangulo legenda
	imagerectangle($img, 500, 150, 680, 200, $black);
	imagefilledrectangle($img, 510, 160, 520, 170, $blue);
	imagefilledrectangle($img, 510, 180, 520, 190, $red);
	
	imagestring($img, 2, 530, 158, "Total (%)", $black);
	imagestring($img, 2, 530, 178, "Acumulado (%)", $black);
	// fim do retangulo
	
	imagegif($img);
	imagedestroy($img);
}

$ind = array($_GET['a1'], $_GET['b1'], $_GET['c1']);
$acu = array($_GET['a2'], $_GET['b2'], $_GET['c2']);

grafico($ind, $acu);

?>