document.addEventListener("DOMContentLoaded", function() {
	toastr.options = {"positionClass": "toast-bottom-right"};
	var page = $("#page").val();
	if (page === 'comissaoponto') {
		$(document).ready(function(){
			$('.data').datepicker({
				format: 'dd/mm/yyyy',
				language: 'pt-BR',
				autoclose: true
			});
		});
		$("#de").mask('00/00/0000');
		$("#ate").mask('00/00/0000');
		var dates = currentDate();
		$('#de').val(dates[0]);
		$('#ate').val(dates[1]);
	}
});

function currentDate() {
	var d = new Date();
	var day = d.getDate();
	var month = d.getMonth() + 1;
	if (day < 10) {day = '0'+day};
	if (month < 10) {month = '0'+month};
	var de = '01/'+month+'/'+d.getFullYear();
	var para = day+'/'+month+'/'+d.getFullYear();
	return [de, para];
}

function pickOperadores() {
	var data = {action: 'getOperadores'};
	$.post('relatorios/resources/php/comissao.php', data, function(response){
		if (response) {
			var options = '<li><div class="checkbox"><label><input id="checkAllOp" type="checkbox" checked="checked" onclick="checkAllOp()"><b>Selecionar todos</b></label></div></div></li>';
			for (var i = 0; i < response.length; i++) {
				options += '<li><div class="checkbox"><label>';
				options += '<input type="checkbox" checked="checked" id="idOp'+response[i]['idOperador']+'">'+ response[i]['idOperador'] + ' - ' +response[i]['stApelido'];
				if (response[i]['stCargo'].length > 2) {
					options += ' - ' + response[i]['stCargo'];
				}
				options += '</label>';
				options += '</div></li>';
			}
			$(options).appendTo($('#list_Operadores'));
			$('#divPeriodo').attr('hidden', 'hidden');
			$('#divOperadores').removeAttr('hidden');
		}else{
			var options = '<li><p>Nenhum resultado foi encontrado</p></li>';
			$(options).appendTo($('#list_Operadores'));
			swal('Erro', 'Nenhum operador atende a pesquisa', 'error')
		}
	});
}

function voltarPeriodo() {
	$('#divOperadores').attr('hidden', 'hidden');
	$('#divPeriodo').removeAttr('hidden');
	$('#list_Operadores').html('');
}

function voltarOperadores() {
	$('#divComissaoPontos').attr('hidden', 'hidden');
	$('#divOperadores').removeAttr('hidden');
	$('#bodyComissaoPonto').html('');
}

function checkAllOp() {
	if ($('#checkAllOp').is(':checked')) {
		$('*[id*=idOp]').each(function(){
			$(this).prop('checked', true);
		});
	}else{
		$('*[id*=idOp]').each(function(){
			$(this).prop('checked', false);
		});
	}
}

function gerarRelatorio() {
    console.log('gerarRelatorio()');
	var ids = '';
	$('*[id*=idOp]').each(function(){
		if($(this).is(':checked')){
			ids += $(this).attr('id').replace('idOp', '') + ', ';
		}
	});
	if (ids.length === 0) {return false;}
	ids = ids.slice(0, -2);
	var data = {action: 'gerarRelatorio', de: $('#de').val(), ate: $('#ate').val(), ids: ids};
	$.post('relatorios/resources/php/comissao.php', data, function(response){
		var date = new Date();
		var day = date.getDate();
		if (day < 10) {day = '0'+day;}
		var month = date.getMonth() + 1;
		if (month < 10) {month = '0'+month;}

		$("#titulo").html('Relatório emitido por <b>'+response['stOperador']+'</b> ['+response['idOperador']+'] em '+day+'/'+month+'/'+date.getFullYear()+' às '+date.getHours()+':'+date.getMinutes()+'H');
		$('#periodo').html('Referente ao período de '+$('#de').val()+' até '+$('#ate').val());
		$('#vrRepique').html('R$ '+response['repique']);
		var linha = '';
		if (response['vendas']){
			for (var i = 0; i < response['vendas'].length; i++) {
				var current = response['vendas'][i];
				linha += '<tr>';
				linha += '<td style="padding:0px">'+current['stApelido']+'</td>';
				linha += '<td style="text-align:right; padding:0px">R$ '+current['vrTotal']+'</td>';
				linha += '<td style="text-align:right; padding:0px">'+current['nrPontos']+'</td>';
				linha += '<td style="text-align:right; padding:0px">R$ '+current['vrSubTotal']+'</td>';
				linha += '<td style="text-align:right; padding:0px">'+current['porcentagem']+' %</td>';
				linha += '</tr>';
			}
		}
		$(linha).appendTo($('#bodyComissaoPonto'));
		$('#divOperadores').attr('hidden', 'hidden');
		$('#divComissaoPontos').removeAttr('hidden');
	});

}
