<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    /**
     * The Artisan commands provided by your application.
     *
     * @var array
     */
    protected $commands = [
        '\App\Console\Commands\GetInvoices',
    ];

    /**m
     * Define the application's command schedule.
     *
     * @param \Illuminate\Console\Scheduling\Schedule $schedule
     * @return void
     */
    protected function schedule(Schedule $schedule)
    {
        $schedule->command('invoices:get')->hourly();
        $schedule->command('close:pdv')->hourly();
        $schedule->command('bloqueia:comanda')->hourly();
        $schedule->command('bloqueia:pedido')->hourly();
        $schedule->command('limpar:ficha')->daily();
//        $schedule->command('desenfila:send')->everyMinute();
//        $schedule->command('desenfila:getpaid')->everyMinute();
//        $schedule->command('desenfila:getpaid')->cron('* * * * *');

    }

    /**
     * Register the commands for the application.
     *
     * @return void
     */
    protected function commands()
    {
        $this->load(__DIR__ . '/Commands');

        require base_path('routes/console.php');
    }
}
