<?php

namespace App\Entities;

use App\Entities\Nati\Product;
use Illuminate\Database\Eloquent\Model;
use App\Traits\HasCompositePrimaryKey;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Items extends Model implements Transformable
{
    use TransformableTrait;
    //    use HasCompositePrimaryKey;

    protected $table = 'cx_Itens';
    protected $primaryKey = ['idItem', 'idVenda', 'idAbertura'];
    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'id_item',
        'id_venda',
        'id_open',
        'id_product',
        'date',
        'quantity',
        'cost',
        'value_unity',
        'discount',
        'active',
        'id_command',
        'id_cod_product',
        'value_total',
        'total_cost',
        'id_operator_autorize',
        'clerk',
        'is_stock_down',
        'is_promotion',
        'update_date',

    ];

    protected $maps = [
        'idItem',
        'idVenda',
        'idAbertura',
        'idProduto',
        'dtData',
        'nrQuantidade',
        'vrCusto',
        'vrUnitario',
        'vrDesconto',
        'flAtivo',
        'idComanda',
        'idCodProduto',
        'vrTotal',
        'vrTotalCusto',
        'idOperadorAutorizador',
        'stAtendente',
        'flEstoqueBaixado',
        'flPromocao',
        'dtAlteracao'
    ];

    protected $casts = [
        'idItem' => 'integer',
        'idVenda' => 'integer',
        'idAbertura' => 'integer',
        'nrQuantidade' => 'float',
        'vrCusto' => 'float',
        'vrUnitario' => 'float',
        'vrDesconto' => 'float',
        'vrTotal' => 'float',
        'vrTotalCusto' => 'float',
        'flAtivo' => 'boolean',
        'flEstoqueBaixado' => 'boolean',
        'flPromocao' => 'boolean',
    ];

    public function produto()
    {
        return $this->belongsTo(Product::class, 'idProduto', 'idProduto');
    }

    public function venda(){
        return $this->hasMany(Sale::class, ['idVenda', 'idAbertura'], ['idVenda', 'idAbertura']);
    }
}

