<?php


namespace App\Entities\Mobyo;


use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Entities\Delivery\MobyoConfig;

class Integration
{
    public $engine;
    private $idCliente;
    public $codProdutoGenerico;
    public $idCaixa;
    public $idUser;
    public $idDeliveryPadrao;
    public $flSalvarClienteObservacao;
    public $flSalvarTaxaEntrega;
    public $flEmitirCupomDelivery;
    public $flEmitirCupomRemoto;
    public $flSalvarVendaAutomaticamente;
    public $flDespacharPedidoAutomaticamente;
    public $flEmitirCFEAutomaticamente;

    public function __construct($engine)
    {
        $this->setIntegration($engine);
    }

    private function setIntegration($engine)
    {
        $integration = $this->getIntegrationFromDB($engine);

        $this->engine = $integration['engine'];
        $this->idCliente = $integration['idCliente'];
        $this->codProdutoGenerico = $integration['codProdutoGenerico'];
        $this->idCaixa = $integration['idCaixa'];
        $this->idUser = $integration['idUser'];
        $this->idDeliveryPadrao = $integration['idDeliveryPadrao'];
        $this->flSalvarClienteObservacao = $integration['flSalvarClienteObservacao'];
        $this->flSalvarTaxaEntrega = $integration['flSalvarTaxaEntrega'];
        $this->flEmitirCupomDelivery = $integration['flEmitirCupomDelivery'];
        $this->flEmitirCupomRemoto = $integration['flEmitirCupomRemoto'];
        $this->flSalvarVendaAutomaticamente = $integration['flSalvarVendaAutomaticamente'];
        $this->flDespacharPedidoAutomaticamente = $integration['flDespacharPedidoAutomaticamente'];
        $this->flEmitirCFEAutomaticamente = $integration['flEmitirCFEAutomaticamente'];
    }

    private function getIntegrationFromDB($engine)
    {
        try {
            $integration = MobyoConfig::where('engine', $engine)
                                        ->with('payments')
                                        ->first();
            if (!$integration['flAtivo']) {
             throw new \Exception('Nati: Engine não habilitada');
            } elseif ($integration['idCliente'] === null && $integration['flClienteFixo']) {
             throw new \Exception('Nati: Id do Cliente não pode ser nulo');
            } elseif ($integration['codProdutoGenerico'] === null) {
             throw new \Exception('Nati: Codigo do produto generico não pode ser nulo');
            }

            return $integration;
        } catch (\Exception $e) {
            throw new \Exception($e);
        }
    }
}
