<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class Permission extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'op_Permissoes';
    protected $primaryKey = 'idPermissao';
    public $incrementing = false;
    public $timestamps = false;

    protected $fillable = [
        'idPermissao',
        'stPermissao',
        'idCategoria',
        'stDescricao',
        'dtAlteracao',
        'categoria'
    ];



    public function categoria()
    {
        return $this->belongsTo(CategoryPermission::class, 'idCategoria', 'idCategoria');
    }
}
