<?php

namespace App\Entities;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;
use Prettus\Repository\Contracts\Transformable;
use Prettus\Repository\Traits\TransformableTrait;

class SaleTemp extends Model implements Transformable
{
    use TransformableTrait;

    protected $table = 'cx_Vendas_Temp';
    protected $primaryKey = ['idVenda', 'idAbertura'];

    public $timestamps = false;
    public $incrementing = false;

    protected $fillable = [
        'idVenda',
        'idAbertura',
        'vrTotal',
        'flNotaFiscal',
        'dtData',
        'idCliente',
        'vrDesconto',
        'vrAcrescimo',
        'flAtivo',
        'nrTempoAtendimento',
        'idOperadorAutorizador',
        'stFraseCupom',
        'flDelivery',
        'idAtendimentoDelivery',
        'stContaAssinada',
        'dtAlteracao',
        'nrCOO',
        'stCPF',
        'chave_fiscal',
        'uuid'
    ];

    protected $casts = [
        'flNotaFiscal' => 'boolean',
        'flAtivo' => 'boolean',
        'flDelivery' => 'boolean',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $this->vrDesconto = 0;
        $this->vrAcrescimo = 0;
        $this->flAtivo = true;
        $this->nrCOO = '';
        $this->stContaAssinada = '';
        $this->dtAlteracao = Carbon::now();
        $this->stFraseCupom = '';
        $this->nrTempoAtendimento = 0;
        $this->dtData = Carbon::now();
    }

    public function abertura()
    {
        return $this->belongsTo(Manager::class, 'idAbertura', 'idAbertura');
    }

    public function detalhes()
    {
        return $this->hasOne(SaleDetailsTemp::class, 'idVenda', 'idVenda');
    }

    public function itens()
    {
        return $this->hasMany(CxItemsTemp::class, 'idVenda', 'idVenda')
            ->where('idAbertura', $this->idAbertura);
    }

    public function paymentsTemp()
    {
        return $this->hasMany(ReceiptFormTemp::class, 'idVenda', 'idVenda')
            ->where('idAbertura', $this->idAbertura);
    }

    public static function boot()
    {
        parent::boot();
        self::creating(function ($model) {
            $model->uuid = (string)Str::uuid();
        });
    }
}
