<?php


namespace App\Exports\Nati;

use App\Entities\Nati\Product;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Illuminate\Support\Facades\DB;
use Maatwebsite\Excel\Concerns\FromArray;

class ProductsExportMobyo implements FromArray
{

    public function array() : array
    {
        $products = DB::select("
            select
            'ID_LOJA' = NULL,
            'DEPARTAMENTO' = NULL,
            cat.stCategoria as 'CATEGORIA',
            sub.stSubCategoria as 'SUBCATEGORIA',
            'MARCA' = NULL,
            CASE
                WHEN m.flFracionado = 1 THEN 'KG'
                ELSE 'UN'
            END AS 'UNIDADE',
            'VOLUME' = NULL,
            CASE
                WHEN len(max(C.idCodigo)) >= 6  then max(C.idCodigo)
                ELSE null
            END AS 'CODIGO_BARRA',
            p.stProdutoAbreviado as 'NOME',
            'DT_CADASTRO' = NULL,
            'DT_ULTIMA_ALTERACAO' = NULL,
            p.vrUnitario as 'VLR_PRODUTO',
            'VLR_PROMOCAO' = NULL,
            est.nrQuantidade as 'QTD_ESTOQUE_ATUAL',
            est.nrMinimo as 'QTD_ESTOQUE_MINIMO',
            'DESCRICAO' = NULL,
            'ATIVO' = NULL,
            CASE
                WHEN len(MIN(C.idCodigo)) <= 6  then MIN(C.idCodigo)
                ELSE null
            END AS 'PLU',
            p.vrCusto as 'VLR_COMPRA',
            'VALIDADE_PROXIMA' = null,
            'VLR_ATACADO' = NULL,
            'QTD_ATACADO' = NULL,
            'IMAGE_URL' = NULL
                    from prd_produtos p
                    join prd_categorias cat on cat.idCategoria = p.idCategoria
                    join prd_SubCategorias sub on sub.idCategoria = p.idCategoria and sub.idSubCategoria = p.idSubCategoria
                    join prd_medidas m on m.idMedida = p.idMedida
                    join prd_Setores s on s.idSetor = p.idSetor
                    join prd_Aliquotas a on a.idAliquota = p.idAliquota
                    join prd_Codigos c on c.idProduto = p.idProduto
                    JOIN est_saldos est on p.idProduto = est.idProduto
                    where p.flAtivo = 1
                    and c.idCodigo <> '-100'
                    group by p.idProduto, codigo, p.stProdutoAbreviado, cat.stCategoria, sub.stSubCategoria, m.stMedida, M.flFracionado, p.nrNcm, p.vrCusto, p.vrUnitario, s.stSetor, a.stAliquota, p.dtUltimaAlteracao, est.nrQuantidade, est.nrMinimo
                    order by p.stProdutoAbreviado ASC
        ");

        array_unshift($products, [
            'ID_LOJA',
            'DEPARTAMENTO',
            'CATEGORIA',
            'SUBCATEGORIA',
            'MARCA',
            'UNIDADE',
            'VOLUME',
            'CODIGO_BARRA',
            'NOME',
            'DT_CADASTRO',
            'DT_ULTIMA_ALTERACAO',
            'VLR_PRODUTO',
            'VLR_PROMOCAO',
            'QTD_ESTOQUE_ATUAL',
            'QTD_ESTOQUE_MINIMO',
            'DESCRICAO',
            'ATIVO',
            'PLU',
            'VLR_COMPRA',
            'VALIDADE_PROXIMA',
            'VLR_ATACADO',
            'QTD_ATACADO',
            'IMAGE_URL'
        ]);

        return $products;
    }
}
