<?php


namespace App\Http\Controllers\Auth;

use App\Entities\User;
use App\Entities\Client;
use App\Http\Controllers\Controller;
use App\Http\Requests\UserLoginRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class JwtLoginController extends Controller
{
    /**
     * Create a new AuthController instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth:api', ['except' => ['login']]);
    }

    public function login(UserLoginRequest $request)
    {
        $token = null;

        $username = $request->username;
        $password = $request->password;
        $pswd = Str::upper(md5($password));

        if (is_numeric($username)) {
            $user = User::find($username);
        } else {
            $user = User::where('stApelido', $username)->where('flAtivo', true)->first();
        }

        $p = Str::upper($user->stSenha);
        $d =Str::upper(md5($password));
        if($user == null || $pswd != Str::upper($user->stSenha)) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }
        try {
            if ($token = auth()->login($user)) {
                return $this->respondWithToken($token);
            }
        }catch (\Exception $e){
            $x = 1;
        }


        return response()->json(['error' => 'Unauthorized'], 401);
    }

    /**
     * Get the authenticated User
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function me()
    {
        return response()->json($this->guard()->user());
    }

    /**
     * Log the user out (Invalidate the token)
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function logout()
    {
        auth()->logout();

        return response()->json(['message' => 'Successfully logged out']);
    }

    /**
     * Refresh a token.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function refresh()
    {
        return $this->respondWithToken(auth()->refresh());
    }

    /**
     * Get the token array structure.
     *
     * @param  string $token
     *
     * @return \Illuminate\Http\JsonResponse
     */
    protected function respondWithToken($token)
    {
        return response()->json([
            'access_token' => $token,
            'token_type' => 'bearer',
            'expires_in' => auth()->factory()->getTTL() * 60
        ]);
    }

}
