<?php

namespace App\Http\Controllers\Delivery;

use Exception;
use Illuminate\Http\Request;
use App\Services\Delivery\MobyoConfigService;
use App\Http\Controllers\Controller;
use App\Validators\MobyoConfigValidator;
use App\Http\Requests\MobyoConfigUpdateRequest;

class MobyoConfigController extends Controller
{
    /**
     * @param MobyoConfigService $service
     */
    public function __construct(MobyoConfigService $service)
    {
        $this->service = $service;
    }

    public function index()
    {
        try {
            $configs = $this->service->get();
            return response()->json($configs);
        } catch (Exception $exception) {
            return response()->json([
                'erro' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function getMobyoConfig($id)
    {
        try {
            $config = $this->service->getMobyoConfig($id);
            return response()->json($config);
        } catch (Exception $exception) {
            return response()->json([
                'erro' => true,
                'message' => $exception->getMessage()
            ], 404);
        }
    }

    public function update(MobyoConfigUpdateRequest $request, $id)
    {
        try{
            $response = $this->service->update($request->all(), $id);
            return response()->json(['data' => $response]);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }

    public function delete($id)
    {
        try{
            $response = $this->service->delete($id);
            return response()->json(['data' => $response]);
        } catch (\Exception $exception) {
            return response()->json([
                'error' => true,
                'message' => $exception->getMessage()
            ], 400);
        }
    }
}
